/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyleTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableHeaderCellDecorator;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortableTableHeader
extends CellStyleTableHeader {
    private static final String \u1e74 = "SortableTableHeaderUI";
    private static final String \u1e75 = "TableHeader.sortableTableHeaderUIDelegate";
    private boolean \u1e76 = true;
    private TableHeaderCellDecorator \u1e73;
    public static final String PROPERTY_SHOW_SORT_ARROW = "showSortArrow";

    public SortableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
    }

    public SortableTableHeader(JTable jTable) {
        this(jTable.getColumnModel());
        this.setTable(jTable);
        this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
    }

    @Override
    public String getActualUIClassID() {
        return \u1e74;
    }

    @Override
    public String getUIDelegateClassID() {
        return \u1e75;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.\u02e0();
        super.paintComponent(graphics);
    }

    private void \u02e0() {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        int[] nArray = new int[list.size()];
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            nArray[i2] = sortableTable.convertColumnIndexToView(sortItem.getColumn());
        }
        sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", nArray);
        sortableTable.putClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND", true);
    }

    @Deprecated
    protected void paintSortArrows(Graphics graphics) {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            int n2 = sortItem.getColumn();
            if (n2 < 0) continue;
            boolean bl = false;
            if (tableColumn != null && tableColumn.getModelIndex() == n2) {
                bl = true;
            }
            if ((n2 = sortableTable.convertColumnIndexToView(n2)) == -1) continue;
            boolean bl2 = sortItem.isAscending();
            Rectangle rectangle = this.getHeaderRect(n2);
            if (bl) {
                rectangle.x += this.getDraggedDistance();
            }
            this.paintSortArrow(this, sortableTable, graphics, rectangle, sortableTable.isShowSortOrderNumber() || list.size() > 1 ? i2 : -1, bl2);
        }
    }

    @Deprecated
    protected void paintSortArrow(JComponent jComponent, SortableTable sortableTable, Graphics graphics, Rectangle rectangle, int n2, boolean bl) {
        Icon icon = this.createSortIcon(sortableTable, bl);
        boolean bl2 = sortableTable.isMultiColumnSortable();
        Color color = sortableTable.getSortOrderForeground() != null ? sortableTable.getSortOrderForeground() : jComponent.getForeground();
        Object object = UIDefaultsLookup.get("Theme.painter");
        if (object instanceof ThemePainter) {
            ((ThemePainter)object).paintSortableTableHeaderColumn(sortableTable.getTableHeader(), graphics, rectangle, 0, 0, bl ? 1 : 2, icon, n2, color, bl2);
        }
    }

    protected Icon createSortIcon(SortableTable sortableTable, boolean bl) {
        return sortableTable.createSortIcon(bl);
    }

    public boolean isShowSortArrow() {
        return this.\u1e76;
    }

    public void setShowSortArrow(boolean bl) {
        boolean bl2 = this.\u1e76;
        if (bl2 != bl) {
            this.\u1e76 = bl;
            if (this.\u1e76) {
                this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
            } else {
                this.removeCellDecorator(this.getSortableTableHeaderCellDecorator());
            }
            this.firePropertyChange(PROPERTY_SHOW_SORT_ARROW, bl2, this.\u1e76);
        }
    }

    public TableHeaderCellDecorator getSortableTableHeaderCellDecorator() {
        if (this.\u1e73 == null) {
            this.\u1e73 = this.createSortableTableHeaderCellDecorator();
        }
        return this.\u1e73;
    }

    protected TableHeaderCellDecorator createSortableTableHeaderCellDecorator() {
        return new SortableTableHeaderCellDecorator();
    }
}

