/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.StreamEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedOutputStream
extends OutputStream {
    private OutputStream father = null;
    private StreamEncoder encryptor = null;
    ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
    byte[] header = null;

    public EncryptedOutputStream(OutputStream outputStream) {
        this.father = outputStream;
    }

    public void SetEncryptor(StreamEncoder streamEncoder) {
        this.encryptor = streamEncoder;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.memoryStream.write(byArray, n, n2);
    }

    public void close() throws IOException {
        this.father.close();
    }

    public void setHeader() throws IOException {
        if (this.memoryStream.size() != 21) {
            throw new IOException("Wrong usage of encryptHeader()");
        }
        this.header = this.memoryStream.toByteArray();
        if (null != this.encryptor) {
            this.encryptor.EncryptBytes(this.header, 0, this.header.length);
        }
        this.memoryStream = new ByteArrayOutputStream();
    }

    public void flush() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (null != this.header) {
            byteArrayOutputStream.write(this.header);
            this.header = null;
        }
        if (null == this.encryptor) {
            this.memoryStream.writeTo(byteArrayOutputStream);
        } else {
            byte[] byArray = this.memoryStream.toByteArray();
            this.encryptor.EncryptBytes(byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        this.memoryStream.close();
        byteArrayOutputStream.writeTo(this.father);
        byteArrayOutputStream.close();
        this.memoryStream = new ByteArrayOutputStream();
        this.father.flush();
        this.header = null;
    }
}

