/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.IDockingStrategy;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DockingStrategyClassMapping {
    private Class<? extends IDockingStrategy> defaultStrategyClass;
    private WeakHashMap<Class<?>, Class<? extends IDockingStrategy>> strategyClasses;
    private IDockingStrategy defaultStrategy;
    private WeakHashMap<Class<?>, IDockingStrategy> strategies;

    public DockingStrategyClassMapping(Class<? extends IDockingStrategy> clazz, IDockingStrategy iDockingStrategy) {
        this.defaultStrategyClass = clazz;
        this.defaultStrategy = iDockingStrategy;
        this.strategyClasses = new WeakHashMap(4);
        this.strategies = new WeakHashMap(4);
    }

    public void addStrategyClassMapping(Class<?> clazz, Class<? extends IDockingStrategy> clazz2, IDockingStrategy iDockingStrategy) {
        this.strategyClasses.put(clazz, clazz2);
        if (iDockingStrategy != null) {
            this.strategies.put(clazz, iDockingStrategy);
        }
    }

    public Class<? extends IDockingStrategy> removeStrategyClassMapping(Class<?> clazz) {
        Class<? extends IDockingStrategy> clazz2 = this.strategyClasses.remove(clazz);
        this.strategies.remove(clazz);
        return clazz2;
    }

    public Class<? extends IDockingStrategy> getStrategyClass(Class<?> clazz) {
        if (clazz == null) {
            return this.defaultStrategyClass;
        }
        Class<? extends IDockingStrategy> clazz2 = null;
        Class<?> clazz3 = clazz;
        while (clazz3 != null && clazz2 == null) {
            clazz2 = this.strategyClasses.get(clazz3);
            clazz3 = clazz3.getSuperclass();
        }
        return clazz2 == null ? this.defaultStrategyClass : clazz2;
    }

    public IDockingStrategy getStrategy(Class<?> clazz) {
        if (clazz == null) {
            return this.defaultStrategy;
        }
        IDockingStrategy iDockingStrategy = null;
        Class<?> clazz2 = clazz;
        while (clazz2 != null && iDockingStrategy == null) {
            iDockingStrategy = this.strategies.get(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return iDockingStrategy == null ? this.defaultStrategy : iDockingStrategy;
    }

    public Class<?> getDefaultStrategyClass() {
        return this.defaultStrategyClass;
    }

    public IDockingStrategy getDefaultStrategy() {
        return this.defaultStrategy;
    }
}

