/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.plaf.addons.JYPropertyTableAddon;
import de.javasoft.swing.table.BooleanComboBoxTableCellEditor;
import de.javasoft.swing.table.BooleanComboBoxTableCellRenderer;
import de.javasoft.swing.table.CheckBoxTableCellEditor;
import de.javasoft.swing.table.CheckBoxTableCellRenderer;
import de.javasoft.swing.table.ColorComboBoxTableCellEditor;
import de.javasoft.swing.table.ColorComboBoxTableCellRenderer;
import de.javasoft.swing.table.DateComboBoxTableCellEditor;
import de.javasoft.swing.table.DateComboBoxTableCellRenderer;
import de.javasoft.swing.table.DefaultPropertyTableModel;
import de.javasoft.swing.table.FontComboBoxTableCellEditor;
import de.javasoft.swing.table.FontComboBoxTableCellRenderer;
import de.javasoft.swing.table.HyperlinkTableCellRenderer;
import de.javasoft.swing.table.IntegerGroupTableCellEditor;
import de.javasoft.swing.table.IntegerGroupTableCellRenderer;
import de.javasoft.swing.table.JYComboBoxTableCellEditor;
import de.javasoft.swing.table.JYComboBoxTableCellRenderer;
import de.javasoft.swing.table.NumberTableCellEditor;
import de.javasoft.swing.table.NumberTableCellRenderer;
import de.javasoft.swing.table.ObjectTableCellEditor;
import de.javasoft.swing.table.ObjectTableCellRenderer;
import de.javasoft.swing.table.PropertyTableModel;
import de.javasoft.swing.table.SeparatorTableCellRenderer;
import de.javasoft.swing.table.SliderTableCellEditor;
import de.javasoft.swing.table.SliderTableCellRenderer;
import de.javasoft.swing.table.SpinnerTableCellEditor;
import de.javasoft.swing.table.SpinnerTableCellRenderer;
import de.javasoft.swing.table.TableSeparator;
import de.javasoft.swing.table.TextFieldTableCellEditor;
import de.javasoft.swing.table.UneditableTableCellEditor;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Date;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.plaf.ComponentAddon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JYPropertyTable
extends JTable {
    private static final long serialVersionUID = -5094635508334830971L;
    protected TableCellRenderer defaultRenderer;
    protected TableCellEditor defaultEditor;
    private ObjectTableCellRenderer cellRenderer;
    private ObjectTableCellEditor cellEditor;
    private TableSeparator tableSeparator = new TableSeparator();

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYPropertyTableAddon());
    }

    public JYPropertyTable() {
        this(null);
    }

    public JYPropertyTable(PropertyTableModel propertyTableModel) {
        super(propertyTableModel);
        this.setRowSelectionAllowed(true);
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new DefaultPropertyTableModel();
    }

    @Override
    public PropertyTableModel getModel() {
        return (PropertyTableModel)super.getModel();
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (!(tableModel instanceof PropertyTableModel)) {
            throw new IllegalArgumentException("Model type has to be an instance of " + PropertyTableModel.class);
        }
        super.setModel(tableModel);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        int n = SyntheticaLookAndFeel.getInt("JYPropertyTable.relativeRowHeight", this, 3);
        this.setRowHeight(new JTable(0, 0).getRowHeight() + n);
        this.installDefaultRenderer();
        this.installDefaultEditor();
        this.installRenderers();
        this.installEditors();
    }

    private void installDefaultRenderer() {
        this.defaultRenderer = this.getDefaultRenderer(Object.class);
        this.cellRenderer = new ObjectTableCellRenderer(this.defaultRenderer);
        this.setDefaultRenderer(Object.class, this.cellRenderer);
    }

    private void installDefaultEditor() {
        this.defaultEditor = this.getDefaultEditor(Object.class);
        this.cellEditor = new ObjectTableCellEditor(this.defaultEditor);
        this.setDefaultEditor(Object.class, this.cellEditor);
    }

    protected void installRenderers() {
        this.setPropertyRenderer(Boolean.class, (TableCellRenderer)new BooleanComboBoxTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(Integer.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Integer.class, 0, 0));
        this.setPropertyRenderer(Long.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Long.class, 0, 0));
        this.setPropertyRenderer(Float.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Float.class, 0, 4));
        this.setPropertyRenderer(Double.class, (TableCellRenderer)new NumberTableCellRenderer(this.defaultRenderer, Double.class, 0, 4));
        IntegerGroupTableCellRenderer integerGroupTableCellRenderer = new IntegerGroupTableCellRenderer(this.defaultRenderer);
        this.setPropertyRenderer(Point.class, (TableCellRenderer)integerGroupTableCellRenderer);
        this.setPropertyRenderer(Dimension.class, (TableCellRenderer)integerGroupTableCellRenderer);
        this.setPropertyRenderer(Rectangle.class, (TableCellRenderer)integerGroupTableCellRenderer);
        this.setPropertyRenderer(Insets.class, (TableCellRenderer)integerGroupTableCellRenderer);
        this.setPropertyRenderer(Color.class, (TableCellRenderer)new ColorComboBoxTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(Date.class, (TableCellRenderer)new DateComboBoxTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(Font.class, (TableCellRenderer)new FontComboBoxTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(DefaultComboBoxModel.class, (TableCellRenderer)new JYComboBoxTableCellRenderer(this.defaultRenderer));
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = new CheckBoxTableCellRenderer(this.defaultRenderer);
        this.setPropertyRenderer(DefaultButtonModel.class, (TableCellRenderer)checkBoxTableCellRenderer);
        this.setPropertyRenderer(SpinnerNumberModel.class, (TableCellRenderer)new SpinnerTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(DefaultBoundedRangeModel.class, (TableCellRenderer)new SliderTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(TableSeparator.class, (TableCellRenderer)new SeparatorTableCellRenderer(this.defaultRenderer));
        this.setPropertyRenderer(URL.class, (TableCellRenderer)new HyperlinkTableCellRenderer(this.defaultRenderer));
    }

    protected void installEditors() {
        this.setPropertyEditor(Boolean.class, (TableCellEditor)new BooleanComboBoxTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(Integer.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Integer.class, 0, 0));
        this.setPropertyEditor(Long.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Long.class, 0, 0));
        this.setPropertyEditor(Float.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Float.class, 0, 4));
        this.setPropertyEditor(Double.class, (TableCellEditor)new NumberTableCellEditor(this.defaultEditor, Double.class, 0, 4));
        this.setPropertyEditor(String.class, (TableCellEditor)new TextFieldTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(Point.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Point.class, 2));
        this.setPropertyEditor(Dimension.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Dimension.class, 2));
        this.setPropertyEditor(Rectangle.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Rectangle.class, 4));
        this.setPropertyEditor(Insets.class, (TableCellEditor)new IntegerGroupTableCellEditor(this.defaultEditor, Insets.class, 4));
        boolean bl = SyntheticaLookAndFeel.getBoolean("JYPropertyTable.comboBoxEditor.editable", this, true);
        this.setPropertyEditor(Color.class, (TableCellEditor)new ColorComboBoxTableCellEditor(this.defaultEditor, bl, false, false));
        this.setPropertyEditor(Date.class, (TableCellEditor)new DateComboBoxTableCellEditor(this.defaultEditor, bl, false));
        this.setPropertyEditor(Font.class, (TableCellEditor)new FontComboBoxTableCellEditor(this.defaultEditor, bl, false));
        this.setPropertyEditor(DefaultComboBoxModel.class, (TableCellEditor)new JYComboBoxTableCellEditor(this.defaultEditor, bl, true));
        CheckBoxTableCellEditor checkBoxTableCellEditor = new CheckBoxTableCellEditor(this.defaultEditor);
        this.setPropertyEditor(DefaultButtonModel.class, (TableCellEditor)checkBoxTableCellEditor);
        this.setPropertyEditor(SpinnerNumberModel.class, (TableCellEditor)new SpinnerTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(DefaultBoundedRangeModel.class, (TableCellEditor)new SliderTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(TableSeparator.class, (TableCellEditor)new UneditableTableCellEditor(this.defaultEditor));
        this.setPropertyEditor(URL.class, (TableCellEditor)new UneditableTableCellEditor(this.defaultEditor));
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public TableCellEditor getDefaultEditor() {
        return this.defaultEditor;
    }

    public void setPropertyRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer == null) {
            this.cellRenderer.removeRenderer(clazz);
        } else {
            this.cellRenderer.addRenderer(clazz, tableCellRenderer);
        }
    }

    public TableCellRenderer getPropertyRenderer(Class<?> clazz) {
        return this.cellRenderer.getRenderer(clazz);
    }

    public void setPropertyRenderer(Object object, TableCellRenderer tableCellRenderer) {
        int n = this.getModel().getPropertyRow(object);
        if (tableCellRenderer == null) {
            this.cellRenderer.removeRenderer(n, 1);
        } else {
            this.cellRenderer.addRenderer(n, 1, tableCellRenderer);
        }
    }

    public TableCellRenderer getPropertyRenderer(Object object) {
        int n = this.getModel().getPropertyRow(object);
        return this.cellRenderer.getRenderer(n, 1);
    }

    public void setPropertyEditor(Class<?> clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor == null) {
            this.cellEditor.removeEditor(clazz);
        } else {
            this.cellEditor.addEditor(clazz, tableCellEditor);
        }
    }

    public TableCellEditor getPropertyEditor(Class<?> clazz) {
        return this.cellEditor.getEditor(clazz);
    }

    public void setPropertyEditor(Object object, TableCellEditor tableCellEditor) {
        int n = this.getModel().getPropertyRow(object);
        if (tableCellEditor == null) {
            this.cellEditor.removeEditor(n, 1);
        } else {
            this.cellEditor.addEditor(n, 1, tableCellEditor);
        }
    }

    public TableCellEditor getPropertyEditor(Object object) {
        int n = this.getModel().getPropertyRow(object);
        return this.cellEditor.getEditor(n, 1);
    }

    public void addProperty(Object object, Object object2) {
        this.getModel().setProperty(this.getRowCount(), object, object2);
    }

    public void removeProperty(int n) {
        this.getModel().removeProperty(n);
    }

    public void addSeparator() {
        this.addProperty(this.tableSeparator, this.tableSeparator);
    }
}

