/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shadows;

import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.ShadowComposite;
import com.jidesoft.tooltip.ShadowSettings;
import com.jidesoft.tooltip.ShadowStyle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;

public abstract class PerspectiveShadow
implements ShadowStyle {
    protected double _yRatio = 0.4;
    protected double _xRatio = 0.667;

    @Override
    public BufferedImage createShadow(BufferedImage bufferedImage, BalloonTip balloonTip) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BalloonShape balloonShape = balloonTip.getBalloonShape();
        ShadowSettings shadowSettings = balloonTip.getShadowSettings();
        ShadowComposite shadowComposite = shadowSettings.getShadowComposite();
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Point point = this.translatePixel(i3, i2, n2, n3);
                double d2 = balloonShape.getEdgeDistance(point, balloonTip);
                int n4 = shadowComposite.compose(d2);
                bufferedImage.setRGB(i3, i2, n4);
            }
        }
        ShadowFactory shadowFactory = new ShadowFactory(shadowSettings.getSize(), shadowSettings.getOpacity(), shadowSettings.getColor());
        return shadowFactory.createShadow(bufferedImage);
    }

    @Override
    public Dimension getShadowSize(Dimension dimension) {
        int n2 = dimension.width;
        int n3 = dimension.height;
        int n4 = (int)(this._yRatio * (double)n3);
        int n5 = (int)((double)n2 / this._xRatio);
        return new Dimension(n5, n4);
    }

    protected abstract Point translatePixel(int var1, int var2, int var3, int var4);

    public double getYRatio() {
        return this._yRatio;
    }

    public void setYRatio(double d2) {
        this._yRatio = d2;
    }

    public double getXRatio() {
        return this._xRatio;
    }

    public void setXRatio(double d2) {
        this._xRatio = d2;
    }
}

