/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.SidePaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class SidePane
extends JPanel
implements SwingConstants,
Accessible {
    private final List<SidePaneGroup> \u0103 = new ArrayList<SidePaneGroup>();
    private int \u0101;
    private boolean \u0104 = true;
    private static final String \u0102 = "SidePaneUI";

    public SidePane(int n2) {
        this.setAttachedSide(n2);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    @Override
    public SidePaneUI getUI() {
        return (SidePaneUI)this.ui;
    }

    public void setUI(SidePaneUI sidePaneUI) {
        super.setUI(sidePaneUI);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(\u0102) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((SidePaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return \u0102;
    }

    public void addGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().add(sidePaneGroup);
    }

    public void removeGroup(SidePaneGroup sidePaneGroup) {
        this.getGroups().remove(sidePaneGroup);
    }

    public void removeGroup(int n2) {
        this.removeGroup(this.getGroups().get(n2));
    }

    public List<SidePaneGroup> getGroups() {
        return this.\u0103;
    }

    public int getAttachedSide() {
        return this.\u0101;
    }

    public void setAttachedSide(int n2) {
        if (n2 != 1 && n2 != 5 && n2 != 7 && n2 != 3) {
            throw new IllegalArgumentException("illegal attached side: must be NORTH, SOUTH, WEST, or EAST");
        }
        this.\u0101 = n2;
        this.updateUI();
    }

    public boolean isRollover() {
        return this.\u0104;
    }

    public void setRollover(boolean bl) {
        this.\u0104 = bl;
        this.updateUI();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        SidePaneItem sidePaneItem;
        int n2;
        if (this.getUI() != null && !this.isRollover() && (n2 = this.getUI().getSelectedItemIndex(mouseEvent.getPoint())) != -1 && (sidePaneItem = this.getUI().getItemForIndex(n2)) != null && sidePaneItem.getComponent() instanceof JComponent) {
            return ((JComponent)sidePaneItem.getComponent()).getToolTipText();
        }
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSidePane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSidePane
    extends JPanel.AccessibleJPanel {
        private static final long \u0101 = -6914188774912169441L;

        protected AccessibleSidePane() {
            super(SidePane.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return super.getAccessibleStateSet();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }
    }
}

