/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.DateConverter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.rss.FeedIconsFactory;
import com.jidesoft.rss.b;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.utils.ItemComparator;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class FeedItemTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
StyleModel {
    private int \u0e95 = 10;
    private PersistenceManagerIF \u0e97;
    private List<ItemIF> \u0e99 = new Vector<ItemIF>();
    private ChannelIF \u0e96;
    private boolean \u0e8a = false;
    final CellStyle \u0e94 = new CellStyle();
    final CellStyle \u0e88 = new CellStyle();
    final CellStyle \u0e9a = new CellStyle();
    final CellStyle \u0e8d = new CellStyle();

    public FeedItemTableModel() {
        this(10, null);
    }

    public FeedItemTableModel(int n2) {
        this(n2, null);
    }

    public FeedItemTableModel(int n2, PersistenceManagerIF persistenceManagerIF) {
        this.\u0e95 = n2;
        this.\u0e97 = persistenceManagerIF;
        this.\u0e94.setFontStyle(1);
        this.\u0e88.setIcon(FeedIconsFactory.getImageIcon("icons/unreadFlag.png"));
        this.\u0e8d.setFontStyle(1);
        this.\u0e8d.setIcon(FeedIconsFactory.getImageIcon("icons/rssItem.png"));
        this.\u0e9a.setIcon(FeedIconsFactory.getImageIcon("icons/rssItem.png"));
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.\u0e99.size();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        return n3 == 2 ? DateConverter.DATETIME_CONTEXT : null;
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        return null;
    }

    public long getItemID(int n2) {
        return this.\u0e99.get(n2).getId();
    }

    public ItemIF getItemAt(int n2) {
        if (n2 >= 0 && n2 < this.\u0e99.size()) {
            return this.\u0e99.get(n2);
        }
        return null;
    }

    public int getItemIndex(ItemIF itemIF) {
        return this.\u0e99.indexOf(itemIF);
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        return this.getColumnClass(n3);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        switch (n2) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Date.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (this.getRowCount() > 0) {
            switch (n3) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.\u0e99.get(n2).getTitle();
                }
                case 2: {
                    return this.\u0e99.get(n2).getDate();
                }
                case 3: {
                    return this.\u0e99.get(n2).getCreator();
                }
            }
        }
        return null;
    }

    public void addItemAt(ItemIF itemIF, int n2) {
        this.\u0e99.add(n2, itemIF);
        this.fireTableRowsInserted(n2, n2);
    }

    public void setItemReadStatus(int n2, boolean bl) {
        if (this.\u0e8a) {
            this.\u0e8a = false;
            return;
        }
        ItemIF itemIF = this.getItemAt(n2);
        itemIF.setUnRead(bl);
        try {
            if (this.\u0e97 != null) {
                this.\u0e97.updateItem(itemIF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableRowsUpdated(n2, n2);
    }

    public void toggleItemReadStatus(int n2) {
        ItemIF itemIF;
        itemIF.setUnRead(!(itemIF = this.getItemAt(n2)).getUnRead());
        this.\u0e8a = true;
        try {
            if (this.\u0e97 != null) {
                this.\u0e97.updateItem(itemIF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableRowsUpdated(n2, n2);
    }

    public void setAllItemReadStatus(boolean bl) {
        for (ItemIF itemIF : this.\u0e99) {
            itemIF.setUnRead(bl);
            try {
                if (this.\u0e97 == null) continue;
                this.\u0e97.updateItem(itemIF);
            }
            catch (Exception exception) {}
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void removeAll() {
        int n2 = this.getRowCount();
        this.\u0e99.clear();
        if (n2 > 0) {
            this.fireTableRowsDeleted(0, n2 - 1);
        }
    }

    @Override
    public CellStyle getCellStyleAt(int n2, int n3) {
        ItemIF itemIF = this.getItemAt(n2);
        if (itemIF.getUnRead()) {
            if (n3 == 0) {
                return this.\u0e88;
            }
            if (n3 == 1) {
                return this.\u0e8d;
            }
            return this.\u0e94;
        }
        if (n3 == 1) {
            return this.\u0e9a;
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return true;
    }

    public void openChannel(ChannelIF channelIF) {
        if (channelIF == null) {
            return;
        }
        if (channelIF.equals(this.\u0e96)) {
            this.\u0e8a = false;
        }
        this.\u0e96 = channelIF;
        int n2 = 0;
        Set set = channelIF.getItems();
        ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
        Arrays.sort(itemIFArray, new ItemComparator(true));
        this.removeAll();
        for (ItemIF itemIF : itemIFArray) {
            if (n2 >= this.getMaxItems()) break;
            this.\u0e99.add(itemIF);
            ++n2;
        }
        if (n2 > 0) {
            this.fireTableRowsInserted(0, n2 - 1);
        }
    }

    public void closeCurrentChannel() {
        this.removeAll();
        this.\u0e96 = null;
    }

    protected String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public ResourceBundle getResourceBundle() {
        return b.\u0101(Locale.getDefault());
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 1: {
                return this.getResourceString("RssFeeds.tableColumn.title");
            }
            case 2: {
                return this.getResourceString("RssFeeds.tableColumn.date");
            }
            case 3: {
                return this.getResourceString("RssFeeds.tableColumn.author");
            }
        }
        return " ";
    }

    public PersistenceManagerIF getPersistenceManager() {
        return this.\u0e97;
    }

    public void setPersistenceManager(PersistenceManagerIF persistenceManagerIF) {
        this.\u0e97 = persistenceManagerIF;
    }

    public int getMaxItems() {
        return this.\u0e95;
    }

    public void setMaxItems(int n2) {
        this.\u0e95 = n2;
    }

    public ChannelIF getChannel() {
        return this.\u0e96;
    }

    public void setChannel(ChannelIF channelIF) {
        this.\u0e96 = channelIF;
    }
}

