/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.DefaultSummaryCalculator;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class GroupTablePopupMenuCustomizer
implements TableHeaderPopupMenuCustomizer {
    public static final String CONTEXT_MENU_UNGROUP = "GroupTable.ungroup";
    public static final String CONTEXT_MENU_GROUP = "GroupTable.group";
    public static final String CONTEXT_MENU_SUMMARY = "GroupTable.summary";
    public static final String CONTEXT_MENU_EXPAND = "GroupTable.expandColumn";
    public static final String CONTEXT_MENU_COLLAPSE = "GroupTable.collapseColumn";
    public static final String CONTEXT_MENU_EXPAND_ALL = "GroupTable.expandAll";
    public static final String CONTEXT_MENU_COLLAPSE_ALL = "GroupTable.collapseAll";
    private int[] \u0103;
    private Set<Integer> \u0102;
    private Locale \u0101;

    public int[] getGroupableColumns() {
        return this.\u0103;
    }

    public void setGroupableColumns(int[] nArray) {
        this.\u0103 = nArray;
    }

    private Set<Integer> \u0101() {
        int[] nArray;
        if (this.\u0102 == null) {
            this.\u0102 = new HashSet<Integer>();
        }
        if ((nArray = this.getGroupableColumns()) != null) {
            for (int n2 : nArray) {
                this.\u0102.add(n2);
            }
        } else {
            this.\u0102.clear();
        }
        return this.\u0102;
    }

    private boolean \u0101(int n2) {
        Set<Integer> set = this.\u0101();
        return set.size() == 0 || set.contains(n2);
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(this.\u0101 != null ? this.\u0101 : Locale.getDefault()).getString(string);
    }

    @Override
    public void customizePopupMenu(final JTableHeader jTableHeader, JPopupMenu jPopupMenu, int n2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n3;
        this.\u0101 = jTableHeader.getLocale();
        if (!(jTableHeader.getTable() instanceof GroupTable)) {
            return;
        }
        final GroupTable groupTable = (GroupTable)jTableHeader.getTable();
        final DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(groupTable.getModel(), DefaultGroupTableModel.class);
        if (defaultGroupTableModel == null) {
            return;
        }
        TableModel tableModel = defaultGroupTableModel.getActualModel();
        int n4 = n2 >= 0 ? groupTable.convertColumnIndexToModel(n2) : n2;
        int n5 = defaultGroupTableModel.getGroupColumnCount();
        int n6 = n4 >= 0 ? defaultGroupTableModel.getActualColumnAt(n4) : (n3 = n4 > -2 || n4 <= -2 - n5 ? n4 : defaultGroupTableModel.getGroupColumnAt(-2 - n4));
        if (n2 >= 0 && n3 >= 0 && groupTable.getColumnCount() > 1 && defaultGroupTableModel.isColumnGroupable(n3) && this.\u0101(n3)) {
            String string = tableModel.getColumnName(n3);
            object4 = new JMenuItem(this.getResourceString(CONTEXT_MENU_GROUP) + "(" + this.getResourceString("Sort.ascending") + ")");
            ((Component)object4).setName("GroupTable.group: " + string);
            ((AbstractButton)object4).addActionListener(new AbstractAction(){
                private static final long \u0105 = 6635038664900821164L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableUtils.saveColumnOrders(groupTable, false);
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    defaultGroupTableModel.addGroupColumn(n3);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                }
            });
            jPopupMenu.add((JMenuItem)object4);
            object3 = new JMenuItem(this.getResourceString(CONTEXT_MENU_GROUP) + "(" + this.getResourceString("Sort.descending") + ")");
            ((Component)object3).setName("GroupTable.group: " + string + "(descending)");
            ((AbstractButton)object3).addActionListener(new AbstractAction(){
                private static final long \u0105 = 6635038664900821164L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableUtils.saveColumnOrders(groupTable, false);
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    defaultGroupTableModel.addGroupColumn(n3, -1);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                }
            });
            jPopupMenu.add((JMenuItem)object3);
            if (defaultGroupTableModel.isSummaryMode()) {
                object2 = new JMenu(this.getResourceString(CONTEXT_MENU_SUMMARY));
                ((Component)object2).setName(CONTEXT_MENU_SUMMARY);
                object = new DefaultSummaryCalculator();
                int[] nArray = ((DefaultSummaryCalculator)object).getAllowedSummaries(defaultGroupTableModel.getActualModel().getColumnClass(n3));
                int n7 = defaultGroupTableModel.getSummaryTypeAt(n3);
                for (final int n8 : nArray) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(((DefaultSummaryCalculator)object).getSummaryName(groupTable.getLocale(), n8));
                    jCheckBoxMenuItem.addActionListener(new AbstractAction(){
                        private static final long \u0105 = -5539707754960338635L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            defaultGroupTableModel.setSummaryType(n3, n8);
                        }
                    });
                    if (n7 == n8) {
                        jCheckBoxMenuItem.setSelected(true);
                    }
                    ((JMenu)object2).add(jCheckBoxMenuItem);
                }
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        for (int i2 = 0; i2 < defaultGroupTableModel.getGroupColumnCount(); ++i2) {
            final int n9 = defaultGroupTableModel.getGroupColumnAt(i2);
            object3 = tableModel.getColumnName(n9);
            object2 = this.getResourceString(CONTEXT_MENU_UNGROUP);
            object = new JMenuItem(MessageFormat.format((String)object2, object3));
            ((Component)object).setName("GroupTable.ungroup: " + (String)object3);
            ((AbstractButton)object).addActionListener(new AbstractAction(){
                private static final long \u0106 = 2486571101671652864L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    int n2 = -1;
                    if (jTableHeader.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
                        n2 = ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate()).getActualModelPreferredWidth(n9);
                    }
                    defaultGroupTableModel.removeGroupColumn(n9);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                    TableUtils.clearColumnOrdersMemory(groupTable);
                    int n3 = jTableHeader.getTable().convertColumnIndexToView(defaultGroupTableModel.getVisualColumnAt(n9));
                    if (n3 >= 0 && n3 < jTableHeader.getColumnModel().getColumnCount() && n2 > 0) {
                        TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n3);
                        tableColumn.setPreferredWidth(n2);
                        tableColumn.setWidth(n2);
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        if (defaultGroupTableModel.hasGroupColumns()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            if (n3 >= 0 && defaultGroupTableModel.isColumnGrouped(n3)) {
                String string = defaultGroupTableModel.getActualModel().getColumnName(n3);
                object4 = this.getResourceString(CONTEXT_MENU_EXPAND);
                object3 = new JMenuItem(new AbstractAction(MessageFormat.format((String)object4, string)){
                    private static final long \u0104 = -5920488828818748698L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n2 = -1;
                        for (int i2 = defaultGroupTableModel.getGroupColumnCount() - 1; i2 >= 0; --i2) {
                            if (defaultGroupTableModel.getGroupColumnAt(i2) != n3) continue;
                            n2 = i2;
                            break;
                        }
                        if (n2 >= 0) {
                            defaultGroupTableModel.expandGroupColumn(n2);
                        }
                    }
                });
                ((Component)object3).setName(CONTEXT_MENU_EXPAND);
                jPopupMenu.add((JMenuItem)object3);
                object4 = this.getResourceString(CONTEXT_MENU_COLLAPSE);
                object2 = new JMenuItem(new AbstractAction(MessageFormat.format((String)object4, string)){
                    private static final long \u0104 = -4282114364839496014L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n2 = -1;
                        for (int i2 = defaultGroupTableModel.getGroupColumnCount() - 1; i2 >= 0; --i2) {
                            if (defaultGroupTableModel.getGroupColumnAt(i2) != n3) continue;
                            n2 = i2;
                            break;
                        }
                        if (n2 >= 0) {
                            defaultGroupTableModel.collapseGroupColumn(n2);
                        }
                    }
                });
                ((Component)object2).setName(CONTEXT_MENU_COLLAPSE);
                jPopupMenu.add((JMenuItem)object2);
            }
            JMenuItem jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_EXPAND_ALL)){
                private static final long \u0103 = -5539707754960338635L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    groupTable.expandAll();
                }
            });
            jMenuItem.setName(CONTEXT_MENU_EXPAND_ALL);
            jPopupMenu.add(jMenuItem);
            object4 = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_COLLAPSE_ALL)){
                private static final long \u0103 = -6954218961074237551L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    groupTable.collapseAll();
                }
            });
            ((Component)object4).setName(CONTEXT_MENU_COLLAPSE_ALL);
            jPopupMenu.add((JMenuItem)object4);
        }
    }
}

