/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.status;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.status.AbstractCodeEditorStatusBarItem;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class LineBreakStatusBarItem
extends AbstractCodeEditorStatusBarItem
implements PropertyChangeListener,
MouseListener {
    public LineBreakStatusBarItem() {
    }

    public LineBreakStatusBarItem(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        this.setHorizontalAlignment(0);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._editor != null) {
            JidePopupMenu jidePopupMenu = new JidePopupMenu();
            JMenuItem jMenuItem = jidePopupMenu.add(this._editor.getResourceString("LineBreak.fileFormat"));
            jMenuItem.setEnabled(false);
            jidePopupMenu.addSeparator();
            this.\u0101(jidePopupMenu, 0);
            this.\u0101(jidePopupMenu, 1);
            this.\u0101(jidePopupMenu, 2);
            jidePopupMenu.show(this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    private void \u0101(JidePopupMenu jidePopupMenu, final int n2) {
        JMenuItem jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(new AbstractAction(this.getLineBreakText(n2)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineBreakStatusBarItem.this.getCodeEditor().setLineBreakStyle(n2);
            }
        }));
        jMenuItem.setSelected(this.getCodeEditor().getLineBreakStyle() == n2);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateText((Integer)propertyChangeEvent.getNewValue());
    }

    @Override
    public void registerListener(CodeEditor codeEditor) {
        if (codeEditor != null) {
            codeEditor.addPropertyChangeListener("lineBreakStyle", this);
            this.updateText(codeEditor.getLineBreakStyle());
        }
    }

    @Override
    public void unregisterListener(CodeEditor codeEditor) {
        if (codeEditor != null) {
            codeEditor.removePropertyChangeListener("lineBreakStyle", this);
        }
    }

    public String getLineBreakText(int n2) {
        switch (n2) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed");
    }

    public String getLineBreakTooltip(int n2) {
        switch (n2) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc.tooltip");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac.tooltip");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix.tooltip");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed.tooltip");
    }

    public void updateText(int n2) {
        if (this._editor != null) {
            this.setText(this.getLineBreakText(n2));
            this.setToolTipText(this.getLineBreakTooltip(n2));
        }
    }
}

