/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.status;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.status.AbstractCodeEditorStatusBarItem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CaretOverwriteStatusBarItem
extends AbstractCodeEditorStatusBarItem
implements PropertyChangeListener {
    public static final String INSERT = "Insert";
    public static final String OVERWRITE = "Overwrite";

    public CaretOverwriteStatusBarItem() {
    }

    public CaretOverwriteStatusBarItem(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        this.setHorizontalAlignment(0);
        this.setPreferredWidth(80);
    }

    @Override
    public void registerListener(CodeEditor codeEditor) {
        if (codeEditor != null) {
            codeEditor.addPropertyChangeListener(this);
            if (codeEditor.isOverwriteEnabled()) {
                this.setText(codeEditor.getResourceString("CaretMode.overwrite"));
            } else {
                this.setText(codeEditor.getResourceString("CaretMode.insert"));
            }
        }
    }

    @Override
    public void unregisterListener(CodeEditor codeEditor) {
        if (codeEditor != null) {
            codeEditor.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("overwriteEnabled".equals(propertyChangeEvent.getPropertyName())) {
            if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                this.setText(this.getCodeEditor() != null ? this.getCodeEditor().getResourceString("CaretMode.overwrite") : OVERWRITE);
            } else {
                this.setText(this.getCodeEditor() != null ? this.getCodeEditor().getResourceString("CaretMode.insert") : INSERT);
            }
        }
    }
}

