/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.settings;

import com.jidesoft.editor.PredefinedSyntaxStyleSchema;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.settings.StylePanel;
import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StyleListPanel
extends JPanel {
    private JList \u0103;
    private StylePanel \u0102;
    private SyntaxStyleSchema \u0105;
    private String[] \u0101;
    private int \u0104 = -1;

    public StyleListPanel() {
        this.installComponents();
        this.installListeners();
    }

    protected void installComponents() {
        this.\u0103 = new JList(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                dimension.width = 150;
                return dimension;
            }
        };
        this.\u0103.setVisibleRowCount(10);
        this.\u0103.getSelectionModel().setSelectionMode(0);
        this.\u0102 = new StylePanel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)new JScrollPane(this.\u0103), "Before");
        this.add((Component)this.\u0102, "Center");
    }

    protected void installListeners() {
        this.\u0103.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StyleListPanel.this.saveData();
                int n2 = StyleListPanel.this.\u0103.getSelectedIndex();
                StyleListPanel.this.\u0104 = n2;
                if (n2 >= 0 && n2 < StyleListPanel.this.getStyles().getStyleCount()) {
                    StyleListPanel.this.\u0102.setStyle(StyleListPanel.this.getStyles().getStyleByIndex(n2));
                } else {
                    StyleListPanel.this.\u0102.setStyle(null);
                }
                StyleListPanel.this.\u0102.loadData();
            }
        });
    }

    public String[] getNames() {
        return this.\u0101;
    }

    public void setNames(String[] stringArray) {
        this.\u0101 = stringArray;
    }

    public SyntaxStyleSchema getStyles() {
        return this.\u0105;
    }

    public void setStyles(SyntaxStyleSchema syntaxStyleSchema) {
        this.\u0105 = syntaxStyleSchema;
    }

    public void saveData() {
        this.\u0102.saveData();
        if (this.\u0104 != -1 && this.getStyles().getStyleByIndex(this.\u0104) == null) {
            this.getStyles().setStyleByIndex(this.\u0104, this.\u0102.getStyle());
        }
    }

    public void loadData() {
        this.\u0103.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int n2) {
                return StyleListPanel.this.getNames()[n2];
            }

            @Override
            public int getSize() {
                return StyleListPanel.this.getNames().length;
            }
        });
        this.\u0103.setSelectedIndex(0);
    }

    public static void main(String[] stringArray) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JDialog jDialog = new JDialog();
        jDialog.setDefaultCloseOperation(2);
        StyleListPanel styleListPanel = new StyleListPanel();
        styleListPanel.setNames(new String[]{"Comment1", "Comment2", "Keywords1", "Keywords2", "Keywords3", "Literal1", "Literal2", "Label", "Operator", "Invalid", "Error", "Warning"});
        styleListPanel.setStyles(PredefinedSyntaxStyleSchema.getIntellijSyntaxStyles());
        styleListPanel.loadData();
        jDialog.add(styleListPanel);
        jDialog.setLocationRelativeTo(null);
        jDialog.pack();
        jDialog.setVisible(true);
    }
}

