/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxStyle;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.marker.Marker;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class SyntaxUtils {
    public static final String SPECIAL_CHAR_SPACE = "\u00b7";
    public static final String SPECIAL_CHAR_TAB = "\u00bb";
    public static final String SPECIAL_CHAR_END_OF_LINE = "\u00b6";

    private SyntaxUtils() {
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n2, String string) {
        int n3 = n2 + string.length();
        char[] cArray = segment.array;
        if (n3 > segment.offset + segment.count) {
            return false;
        }
        int n4 = n2;
        int n5 = 0;
        while (n4 < n3) {
            char c2 = cArray[n4];
            char c3 = string.charAt(n5);
            if (bl) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
            }
            if (c2 != c3) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n2, char[] cArray) {
        int n3 = n2 + cArray.length;
        char[] cArray2 = segment.array;
        if (n3 > segment.offset + segment.count) {
            return false;
        }
        int n4 = n2;
        int n5 = 0;
        while (n4 < n3) {
            char c2 = cArray2[n4];
            char c3 = cArray[n5];
            if (bl) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
            }
            if (c2 != c3) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    @Deprecated
    public static int paintSyntaxLine(CodeEditor codeEditor, Segment segment, int n2, int n3, Token token, SyntaxStyleSchema syntaxStyleSchema, TabExpander tabExpander, Graphics graphics, int n4, int n5) {
        return SyntaxUtils.paintSyntaxLine(codeEditor, segment, n2, n3, token, syntaxStyleSchema, tabExpander, graphics, n4, n5, 0);
    }

    public static int paintSyntaxLine(CodeEditor codeEditor, Segment segment, int n2, int n3, Token token, SyntaxStyleSchema syntaxStyleSchema, TabExpander tabExpander, Graphics graphics, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        byte by;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        int n10 = 0;
        ArrayList<A> arrayList = new ArrayList<A>();
        while ((by = token.id) != 127) {
            int n11 = n3 != -1 ? Math.min(n3 - n10, token.length) : token.length;
            SyntaxStyle object = syntaxStyleSchema.getStyle(by);
            arrayList.add(new A(n10 + segment.offset, n11, object, by));
            if (n3 != -1 && n3 <= (n10 += n11)) break;
            token = token.next;
        }
        List<Marker> list = codeEditor.getMarkerModel().getMarkersAt(segment.offset + n6, segment.getEndIndex() + n6);
        for (Marker marker : list) {
            A a2;
            if (!marker.isEnabled() || marker.getType() < 128) continue;
            n9 = marker.getStartOffset() - n6;
            int n11 = marker.getEndOffset() - n6;
            n8 = -1;
            n7 = -1;
            int n12 = 0;
            while (n12 < arrayList.size()) {
                a2 = (A)arrayList.get(n12);
                if (n8 < 0 && n9 < a2.\u0101() + a2.\u0103()) {
                    n8 = n12;
                }
                if (n11 < a2.\u0101()) break;
                n7 = n12++;
            }
            if (n8 < 0 || n7 < 0 || codeEditor.getStyles().getStyle(marker.getType()) == null) continue;
            A a3 = (A)arrayList.get(n8);
            a2 = (A)arrayList.get(n7);
            for (int i2 = n8; i2 <= n7; ++i2) {
                arrayList.remove(n8);
            }
            if (n11 < a2.\u0101() + a2.\u0103() - 1) {
                arrayList.add(n8, new A(n11 + 1, a2.\u0101() + a2.\u0103() - n11 - 1, a2.\u0102(), a2.\u0104()));
            }
            arrayList.add(n8, new A(Math.max(n9, a3.\u0101()), Math.min(n11 + 1, a2.\u0101() + a2.\u0103()) - Math.max(n9, a3.\u0101()), codeEditor.getStyles().getStyle(marker.getType()), marker.getType()));
            if (n9 <= a3.\u0101()) continue;
            arrayList.add(n8, new A(a3.\u0101(), n9 - a3.\u0101(), a3.\u0102(), a3.\u0104()));
        }
        n2 += segment.offset;
        for (A a4 : arrayList) {
            n9 = a4.\u0104();
            SyntaxStyle syntaxStyle = a4.\u0102();
            n8 = a4.\u0103();
            n7 = a4.\u0101();
            if (syntaxStyle == null || n9 == 0 && syntaxStyle.getForeground() == null) {
                if (!color.equals(graphics.getColor())) {
                    graphics.setColor(color);
                }
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyle.setGraphicsFlags(graphics, font);
            }
            segment.count = n8;
            segment.offset = n7;
            if (n2 > n7 + n8) continue;
            if (n2 > n7 && n2 <= n7 + segment.count) {
                segment.offset += n2 - n7;
                segment.count -= n2 - n7;
            }
            n4 = SyntaxUtils.\u0101(codeEditor, segment, n4, n5, graphics, tabExpander, 0);
        }
        return n4;
    }

    static int \u0101(CodeEditor codeEditor, String string, int n2) {
        if (string == null) {
            return n2;
        }
        return n2 + codeEditor.getPainter().getFontMetrics().stringWidth(string);
    }

    static int \u0101(CodeEditor codeEditor, Segment segment, int n2, int n3, Token token, int n4) {
        int n5;
        int n6;
        byte by;
        Font font = codeEditor.getPainter().getFont();
        SyntaxStyleSchema syntaxStyleSchema = codeEditor.getStyles();
        Graphics graphics = codeEditor.getPainter().getGraphics();
        if (graphics == null) {
            return 0;
        }
        int n7 = segment.offset;
        int n8 = segment.count;
        int n9 = 0;
        ArrayList<A> arrayList = new ArrayList<A>();
        while ((by = token.id) != 127) {
            int n10 = n3 != -1 ? Math.min(n3 - n9, token.length) : token.length;
            SyntaxStyle object = syntaxStyleSchema.getStyle(by);
            arrayList.add(new A(n9 + segment.offset, n10, object, by));
            if (n3 != -1 && n3 <= (n9 += n10)) break;
            token = token.next;
        }
        List<Marker> list = codeEditor.getMarkerModel().getMarkersAt(segment.offset, segment.getEndIndex());
        for (Marker marker : list) {
            A a2;
            n6 = -1;
            int n10 = -1;
            n5 = 0;
            while (n5 < arrayList.size()) {
                a2 = (A)arrayList.get(n5);
                if (n6 < 0 && marker.getStartOffset() < a2.\u0101() + a2.\u0103()) {
                    n6 = n5;
                }
                if (marker.getEndOffset() < a2.\u0101()) break;
                n10 = n5++;
            }
            if (n6 < 0 || n10 < 0 || codeEditor.getStyles().getStyle(marker.getType()) == null) continue;
            A a3 = (A)arrayList.get(n6);
            a2 = (A)arrayList.get(n10);
            for (int i2 = n6; i2 <= n10; ++i2) {
                arrayList.remove(n6);
            }
            if (marker.getEndOffset() < a2.\u0101() + a2.\u0103() - 1) {
                arrayList.add(n6, new A(marker.getEndOffset() + 1, a2.\u0101() + a2.\u0103() - marker.getEndOffset() - 1, a2.\u0102(), a2.\u0104()));
            }
            arrayList.add(n6, new A(Math.max(marker.getStartOffset(), a3.\u0101()), Math.min(marker.getEndOffset() + 1, a2.\u0101() + a2.\u0103()) - Math.max(marker.getStartOffset(), a3.\u0101()), codeEditor.getStyles().getStyle(marker.getType()), marker.getType()));
            if (marker.getStartOffset() <= a3.\u0101()) continue;
            arrayList.add(n6, new A(a3.\u0101(), marker.getStartOffset() - a3.\u0101(), a3.\u0102(), a3.\u0104()));
        }
        n2 += segment.offset;
        for (A a4 : arrayList) {
            n6 = a4.\u0104();
            SyntaxStyle syntaxStyle = a4.\u0102();
            n5 = a4.\u0103();
            int n11 = a4.\u0101();
            if (n6 == 0) {
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyle.setGraphicsFlags(graphics, font);
            }
            segment.count = n5;
            segment.offset = n11;
            if (n2 > n11 + n5) continue;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (n2 > n11 && n2 <= n11 + segment.count) {
                segment.offset += n2 - n11;
                segment.count -= n2 - n11;
            }
            n4 += Utilities.getTabbedTextWidth(segment, fontMetrics, n4, (TabExpander)codeEditor.getPainter(), 0);
        }
        segment.offset = n7;
        segment.count = n8;
        return n4;
    }

    static int \u0101(CodeEditor codeEditor, Segment segment, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4) {
        return SyntaxUtils.\u0101(codeEditor, segment, n2, n3, graphics, tabExpander, n4, null);
    }

    static JComponent \u0101(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) instanceof JComponent) {
            return (JComponent)container;
        }
        return null;
    }

    static int \u0101(CodeEditor codeEditor, Segment segment, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4, int[] nArray) {
        boolean bl = codeEditor.isSpecialCharactersVisible();
        Color color = codeEditor.getSpecialCharactersColor();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n2;
        char[] cArray = segment.array;
        int n6 = segment.offset;
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = 0;
        int n10 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        int n11 = Math.min(segment.offset + segment.count, cArray.length);
        for (int i2 = n6; i2 < n11; ++i2) {
            Color color2;
            if (cArray[i2] == '\t' || cArray[i2] == ' ') {
                if (n7 > 0) {
                    graphics.drawChars(cArray, n8, n7, n2, n3);
                    n5 = n2 + graphics.getFontMetrics().charsWidth(cArray, n8, n7);
                    n7 = 0;
                }
                n8 = i2 + 1;
                if (cArray[i2] == '\t') {
                    if (bl) {
                        color2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.drawString(SPECIAL_CHAR_TAB, n5, n3);
                        graphics.setColor(color2);
                    }
                    n5 = tabExpander != null ? (int)tabExpander.nextTabStop(n5, n4 + i2 - n6) : (n5 += fontMetrics.charWidth(' '));
                } else if (cArray[i2] == ' ') {
                    if (bl) {
                        color2 = graphics.getColor();
                        graphics.setColor(color);
                        graphics.drawString(SPECIAL_CHAR_SPACE, n5, n3);
                        graphics.setColor(color2);
                    }
                    n5 += fontMetrics.charWidth(' ') + n9;
                    if (i2 <= n10) {
                        // empty if block
                    }
                }
                n2 = ++n5;
                continue;
            }
            if (cArray[i2] == '\n' || cArray[i2] == '\r') {
                if (bl) {
                    color2 = graphics.getColor();
                    graphics.setColor(color);
                    graphics.drawString(SPECIAL_CHAR_END_OF_LINE, n2 + graphics.getFontMetrics().charsWidth(cArray, n8, n7), n3);
                    graphics.setColor(color2);
                }
                if (n7 > 0) {
                    graphics.drawChars(cArray, n8, n7, n2, n3);
                    n5 = n2 + graphics.getFontMetrics().charsWidth(cArray, n8, n7);
                    n7 = 0;
                }
                n8 = i2 + 1;
                n2 = n5;
                continue;
            }
            ++n7;
        }
        if (n7 > 0) {
            graphics.drawChars(cArray, n8, n7, n2, n3);
            n5 = n2 + graphics.getFontMetrics().charsWidth(cArray, n8, n7);
        }
        return n5;
    }

    private static class A {
        private int \u0102;
        private int \u0104;
        private SyntaxStyle \u0101;
        private int \u0103;

        public A(int n2, int n3, SyntaxStyle syntaxStyle, int n4) {
            this.\u0102 = n2;
            this.\u0104 = n3;
            this.\u0101 = syntaxStyle;
            this.\u0103 = n4;
        }

        public int \u0101() {
            return this.\u0102;
        }

        public int \u0103() {
            return this.\u0104;
        }

        public SyntaxStyle \u0102() {
            return this.\u0101;
        }

        public int \u0104() {
            return this.\u0103;
        }
    }
}

