/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.H;
import com.jidesoft.chart.I;
import com.jidesoft.chart.LegendItem;
import com.jidesoft.chart.PointLegendItem;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Named;
import com.jidesoft.range.Category;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Legend
extends JPanel
implements Drawable,
Frontable {
    private static final long \u016c = 3209957448711005879L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int LEADING = 3;
    public static final int RIGHT = 2;
    public static final int TRAILING = 4;
    public static final String PROPERTY_GENERATE_FROM_POINTS = "GenerateFromPoints";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_COLUMNS = "columns";
    public static final String PROPERTY_KEY_LABEL_GAP = "keyLabelGap";
    public static final String PROPERTY_LABEL_COLOR = "labelColor";
    public static final String PROPERTY_LEGEND_BACKGROUND = "legendBackground";
    public static final String PROPERTY_ORDER_REVERSED = "order reversed";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_TITLE_LABEL = "Title Label";
    public static final String PROPERTY_ROLLOVER_MODEL = "Rollover Model";
    private static final Logger \u0178 = Logger.getLogger(Legend.class.getName());
    private GridBagLayout \u0172 = new GridBagLayout();
    private int \u0171 = 1;
    private List<WeakReference<Chart>> \u016d = new ArrayList<WeakReference<Chart>>();
    private Set<ChartModel> \u0179 = new HashSet<ChartModel>();
    private Set<Chartable> \u0177 = new HashSet<Chartable>();
    private List<ChartModel> \u0176 = new ArrayList<ChartModel>();
    private List<LegendItem> \u0174 = new ArrayList<LegendItem>();
    private String \u017b;
    private JLabel \u0181 = null;
    private Color \u017d = null;
    private Color \u017a = null;
    private long \u0173;
    private PropertyChangeListener \u0170;
    private boolean \u016e = false;
    private boolean \u0180 = false;
    private Border \u016f = null;
    private Paint \u0175 = null;
    private boolean \u017f = true;
    private ChartModel \u017e;
    private int \u017c = 0;

    public Legend() {
        this(null, 1);
    }

    public Legend(boolean bl, int n2) {
        this(null, 0);
        if (bl) {
            this.setLayout(new H(n2));
        }
    }

    public Legend(Chart chart) {
        this(chart, 1);
    }

    public Legend(Chart chart, boolean bl) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new H());
        }
    }

    public Legend(Chart chart, boolean bl, int n2) {
        this(chart, 0);
        if (bl) {
            this.setLayout(new H(n2));
        }
    }

    public Legend(Chart chart, int n2) {
        this.\u0171 = n2;
        this.setLayout(this.\u0172);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.\u0170 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("Model".equals(string) || "ChartStyle".equals(string)) {
                    Legend.this.updateLegend();
                }
            }
        };
        if (chart != null) {
            this.addChart(chart);
        }
        B b2 = new B(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                LegendItem legendItem;
                Point point = mouseEvent.getPoint();
                Component component = Legend.this.getComponentAt(point);
                if (component == null) {
                    return;
                }
                if (component instanceof JLabel) {
                    component = ((JLabel)component).getLabelFor();
                }
                if (component instanceof LegendItem && (legendItem = (LegendItem)((Object)component)).getSource() instanceof ChartModel) {
                    ChartModel chartModel = (ChartModel)legendItem.getSource();
                    Legend.this.\u0102(chartModel);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Legend.this.\u0102(null);
            }
        };
        this.addMouseListener(b2);
        this.addMouseMotionListener(b2);
    }

    public int getKeyLabelGap() {
        return this.\u017c;
    }

    public void setKeyLabelGap(int n2) {
        int n3 = this.\u017c;
        this.\u017c = n2;
        this.firePropertyChange(PROPERTY_KEY_LABEL_GAP, n3, n2);
    }

    public Paint getLegendBackground() {
        return this.\u0175 == null ? this.getBackground() : this.\u0175;
    }

    public void setLegendBackground(Paint paint) {
        Paint paint2 = this.\u0175;
        this.\u0175 = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND, paint2, paint);
    }

    public Color getLabelColor() {
        return this.\u017d;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.\u017d;
        this.\u017d = color;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Color getTitleColor() {
        return this.\u017a;
    }

    public void setTitleColor(Color color) {
        Color color2 = this.\u017a;
        this.\u017a = color;
        if (this.\u0181 != null) {
            this.\u0181.setForeground(color);
        }
        this.updateLegend();
        this.firePropertyChange(PROPERTY_TITLE_COLOR, color2, color);
    }

    private void \u0102(ChartModel chartModel) {
        ChartModel chartModel2 = this.\u017e;
        this.\u017e = chartModel;
        this.firePropertyChange(PROPERTY_ROLLOVER_MODEL, chartModel2, chartModel);
    }

    public void addExcludedModels(ChartModel ... chartModelArray) {
        Collections.addAll(this.\u0179, chartModelArray);
        this.updateLegend();
    }

    public void removeExcludedModels(ChartModel ... chartModelArray) {
        for (ChartModel chartModel : chartModelArray) {
            this.\u0179.remove(chartModel);
        }
        this.updateLegend();
    }

    public void clearExcludedModels() {
        this.\u0179.clear();
        this.updateLegend();
    }

    public Legend addIncludedModel(ChartModel chartModel) {
        this.\u0176.add(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend removeIncludedModel(ChartModel chartModel) {
        this.\u0176.remove(chartModel);
        this.updateLegend();
        return this;
    }

    public Legend addLegendItem(LegendItem legendItem) {
        this.\u0174.add(legendItem);
        this.updateLegend();
        return this;
    }

    public Legend removeLegendItem(LegendItem legendItem) {
        this.\u0174.remove(legendItem);
        this.updateLegend();
        return this;
    }

    public void addExcludedPoints(Chartable ... chartableArray) {
        Collections.addAll(this.\u0177, chartableArray);
        this.updateLegend();
    }

    public void removeExcludedPoints(Chartable ... chartableArray) {
        for (Chartable chartable : chartableArray) {
            this.\u0177.remove(chartable);
        }
        this.updateLegend();
    }

    public void clearExcludedPoints() {
        this.\u0177.clear();
    }

    @Override
    public void setBorder(Border border) {
        this.\u016f = border;
        this.updateLegend();
    }

    public void addChart(Chart chart) {
        WeakReference<Chart> weakReference = new WeakReference<Chart>(chart);
        this.\u016d.add(weakReference);
        chart.addPropertyChangeListener(this.\u0170);
        this.updateLegend();
    }

    public void removeChart(Chart chart) {
        for (int i2 = this.\u016d.size() - 1; i2 >= 0; --i2) {
            WeakReference<Chart> weakReference = this.\u016d.get(i2);
            Chart chart2 = (Chart)weakReference.get();
            if (chart2 != null && !chart.equals(chart2)) continue;
            this.\u016d.remove(i2);
        }
        chart.removePropertyChangeListener(this.\u0170);
    }

    int \u0103() {
        return this.\u016d.size();
    }

    public void setColumns(int n2) {
        int n3 = this.\u0171;
        this.\u0171 = n2;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_COLUMNS, n3, n2);
    }

    public void clear() {
        this.\u016d.clear();
    }

    public String getTitle() {
        return this.\u017b;
    }

    public void setTitle(String string) {
        String string2 = this.\u017b;
        if (string == null) {
            this.\u0181 = null;
        } else {
            if (this.\u0181 == null) {
                this.\u0181 = this.createLegendTitle(string);
            }
            this.\u017b = string;
        }
        this.firePropertyChange(PROPERTY_TITLE, string2, string);
        this.updateLegend();
    }

    public JLabel getTitleLabel() {
        return this.\u0181;
    }

    public void setTitleLabel(JLabel jLabel) {
        JLabel jLabel2 = this.\u0181;
        this.\u0181 = jLabel;
        this.firePropertyChange(PROPERTY_TITLE_LABEL, jLabel2, jLabel);
    }

    public boolean isGenerateFromPoints() {
        return this.\u016e;
    }

    public void setGenerateFromPoints(boolean bl) {
        boolean bl2 = this.\u016e;
        this.\u016e = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_GENERATE_FROM_POINTS, bl2, bl);
    }

    public boolean isOrderReversed() {
        return this.\u0180;
    }

    public void setOrderReversed(boolean bl) {
        boolean bl2 = this.\u0180;
        this.\u0180 = bl;
        this.updateLegend();
        this.firePropertyChange(PROPERTY_ORDER_REVERSED, bl2, bl);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateLegend();
    }

    protected void updateLegend() {
        Serializable serializable;
        Object object;
        Object object2;
        WeakReference<Chart> weakReference2;
        Cloneable cloneable;
        this.removeAll();
        super.setBorder(null);
        if (this.\u0181 != null) {
            cloneable = new GridBagConstraints(0, 0, this.\u0171, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
            this.add((Component)this.\u0181, cloneable);
        }
        if (this.\u016d == null) {
            return;
        }
        cloneable = new ArrayList();
        for (WeakReference<Chart> weakReference2 : this.\u016d) {
            object2 = weakReference2 == null ? null : (Chart)weakReference2.get();
            if (object2 == null) continue;
            object = ((Chart)object2).getChartType();
            if (object == ChartType.PIE || this.\u016e) {
                cloneable.addAll(this.\u0101((Chart)object2));
                continue;
            }
            serializable = new ArrayList<ChartModel>(((Chart)object2).getModels());
            for (ChartModel chartModel : this.\u0176) {
                serializable.add((ChartModel)chartModel);
            }
            if (this.isOrderReversed()) {
                Collections.reverse(serializable);
            }
            cloneable.addAll(this.\u0101((Chart)object2, (List<ChartModel>)((Object)serializable)));
        }
        ArrayList<LegendItem> arrayList = new ArrayList<LegendItem>(this.\u0174);
        if (this.isOrderReversed()) {
            Collections.reverse(arrayList);
        }
        weakReference2 = arrayList.iterator();
        while (weakReference2.hasNext()) {
            object2 = (LegendItem)weakReference2.next();
            cloneable.add(this.createLegendPair((LegendItem)object2, this.createLegendLabel(object2.getLabel())));
        }
        int n2 = 0;
        int n3 = 1;
        object = cloneable.iterator();
        while (object.hasNext()) {
            serializable = (I)object.next();
            GridBagConstraints gridBagConstraints = new GridBagConstraints(n2, n3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 0, 2), 10, 0);
            this.add((Component)serializable, gridBagConstraints);
            if (this.\u0171 <= 0 || ++n2 < this.\u0171) continue;
            ++n3;
            n2 = 0;
        }
        if (this.getComponentCount() > 0) {
            super.setBorder(this.\u016f);
        }
        this.\u0173 = System.currentTimeMillis();
    }

    private List<I> \u0101(Chart chart) {
        ArrayList<I> arrayList = new ArrayList<I>();
        ChartModel chartModel = chart.getModel();
        int n2 = 0;
        int n3 = 1;
        if (this.isOrderReversed()) {
            n2 = chartModel.getPointCount() - 1;
            n3 = -1;
        }
        for (int i2 = n2; i2 >= 0 && chartModel != null && i2 < chartModel.getPointCount(); i2 += n3) {
            Chartable chartable = chartModel.getPoint(i2);
            LegendItem legendItem = this.createPointLegendItem(chartable, chartModel, chart);
            JLabel jLabel = this.createLegendLabel(chartable);
            I i3 = this.createLegendPair(legendItem, jLabel);
            arrayList.add(i3);
        }
        return arrayList;
    }

    protected LegendItem createPointLegendItem(Chartable chartable, ChartModel chartModel, Chart chart) {
        return new PointLegendItem(chartable, chartModel, chart);
    }

    private List<I> \u0101(Chart chart, List<ChartModel> list) {
        ArrayList<I> arrayList = new ArrayList<I>();
        for (ChartModel chartModel : list) {
            if (this.\u0179.contains(chartModel)) continue;
            LegendItem legendItem = this.createModelLegendItem(chartModel, chart);
            JComponent jComponent = this.createLegendLabel(chartModel);
            I i2 = this.createLegendPair(legendItem, jComponent);
            arrayList.add(i2);
        }
        return arrayList;
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart) {
        return new A(chartModel, chart);
    }

    protected LegendItem createModelLegendItem(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
        return new A(chartModel, chart, chartStyle);
    }

    protected I createLegendPair(LegendItem legendItem, JComponent jComponent) {
        return new I(this, legendItem, jComponent);
    }

    protected JLabel createLegendLabel(Chartable chartable) {
        Object object;
        if (chartable instanceof Named && (object = ((Named)((Object)chartable)).getName()) != null) {
            return new JLabel((String)object);
        }
        object = chartable.getX();
        String string = Double.toString(object.position());
        if (object instanceof Category) {
            Category category = (Category)object;
            string = category.getName();
        }
        return new JLabel(string);
    }

    protected JComponent createLegendLabel(ChartModel chartModel) {
        return this.createLegendLabel(chartModel.getName());
    }

    protected JComponent createLegendLabel(String string) {
        JLabel jLabel = new JLabel(string, 2);
        if (this.\u017d != null) {
            jLabel.setForeground(this.\u017d);
        }
        jLabel.setFont(this.getFont());
        return jLabel;
    }

    protected JLabel createLegendTitle(String string) {
        JLabel jLabel = new JLabel(string, 0);
        if (this.\u017a != null) {
            jLabel.setForeground(this.\u017a);
        }
        jLabel.setFont(this.getFont());
        return jLabel;
    }

    @Override
    public boolean isAtFront() {
        return this.\u017f;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.\u017f;
        this.\u017f = bl;
        this.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.validate();
        this.doLayout();
        this.setSize(this.getPreferredSize());
        int n2 = this.getX();
        int n3 = this.getY();
        graphics.translate(n2, n3);
        this.print(graphics);
        graphics.translate(-n2, -n3);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.isOpaque()) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = this.\u0175 == null ? this.getBackground() : this.\u0175;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, n2, n3);
        this.setOpaque(false);
        super.paintComponent(graphics);
        this.setOpaque(true);
    }

    long \u0102() {
        return this.\u0173;
    }

    class B
    implements MouseListener,
    MouseMotionListener {
        B() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    static class A
    extends JComponent
    implements LegendItem<ChartModel, ChartModel> {
        private static final long \u010f = 8445473530598990518L;
        private ChartModel \u010c;
        private Chart \u010e;
        private ChartStyle \u010d;

        public A(ChartModel chartModel, Chart chart) {
            this(chartModel, chart, chart.getStyle(chartModel));
        }

        public A(ChartModel chartModel, Chart chart, ChartStyle chartStyle) {
            this.setOpaque(false);
            this.\u010c = chartModel;
            this.\u010e = chart;
            if (chartStyle == null) {
                chartStyle = ChartStyle.DEFAULT_STYLE;
            }
            this.\u010d = chartStyle;
            int n2 = 1 + Math.max(20, chartStyle.getPointSize());
            int n3 = 1 + Math.max(30, chartStyle.getPointSize());
            Dimension dimension = new Dimension(n3, n2);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getLabel() {
            return this.\u010c.getName();
        }

        public ChartModel \u0102() {
            return this.\u010c;
        }

        public ChartModel \u0101() {
            return this.\u010c;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Object object;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension dimension = this.getSize();
            int n2 = dimension.height;
            int n3 = dimension.width;
            if (this.\u010d == null) {
                return;
            }
            if (this.\u010d.isLinesVisible()) {
                object = this.\u010e.getLineRenderer(this.\u010c);
                if (this.\u010d.getLineFill() != null) {
                    int[] nArray = new int[]{5, 5 + (n3 - 10) / 2, n3 - 5};
                    int[] nArray2 = new int[]{3 * n2 / 4, (int)Math.round((double)n2 / 2.0) - 1, 3 * n2 / 4};
                    object.renderLine(graphics2D, null, nArray, nArray2, this.\u010d);
                } else {
                    object.renderLine(graphics2D, null, new int[]{5, n3 - 5}, new int[]{n2 / 2, n2 / 2}, this.\u010d);
                }
            }
            if (this.\u010d.isPointsVisible()) {
                object = this.\u010e.getPointRenderer(this.\u010c);
                object.renderPoint(graphics2D, this.\u010e, this.\u010c, null, false, false, false, n3 / 2, n2 / 2);
            }
            if (this.\u010d.isBarsVisible()) {
                object = this.\u010e.getBarRenderer(this.\u010c);
                object.renderBar(graphics2D, this.\u010e, this.\u010c, null, false, false, false, 5, n2 / 4, n3 - 10, n2 / 2);
            }
            graphics2D.dispose();
        }
    }
}

