/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.xml.Attribute;
import com.nuodb.xml.XmlException;
import java.io.BufferedReader;
import java.io.IOException;

public class Doc {
    StringBuilder document;
    int offset;
    int length;
    Attribute declaration;
    BufferedReader inputStream;
    static final String CDATA = "<![CDATA[";
    static final String endCDATA = "]]>";
    static final String COMMENT = "<!--";
    static final String endCOMMENT = "-->";

    public Doc(String doc) {
        this.document = new StringBuilder(doc);
        this.offset = 0;
        this.length = this.document.length();
    }

    public Doc(BufferedReader stream) {
        this.document = new StringBuilder();
        this.offset = 0;
        this.length = this.document.length();
        this.inputStream = stream;
        this.getLine();
    }

    public void print(String text, int len) {
        this.print(text, this.offset, len);
    }

    public void print(String text, int pos, int len) {
        int end = Math.min(pos + len, this.length);
        System.out.println(text + this.document.substring(pos, end));
    }

    public void setDeclaration(Attribute attributes) {
        this.declaration = attributes;
    }

    public char getChar() throws XmlException {
        if (this.offset >= this.length) {
            throw new XmlException("unexpect end of xml document");
        }
        return this.document.charAt(this.offset);
    }

    public boolean match(char c) {
        if (this.offset < this.length && this.document.charAt(this.offset) == c) {
            ++this.offset;
            return true;
        }
        return false;
    }

    public boolean isChar(char c) {
        return this.offset < this.length && this.document.charAt(this.offset) == c;
    }

    public String parseText() throws XmlException {
        boolean escape = false;
        boolean cdata = false;
        boolean escapes = false;
        do {
            for (int n = this.offset; n < this.length; ++n) {
                char c = this.document.charAt(n);
                if (escape) {
                    if (c != ';') continue;
                    escape = false;
                    continue;
                }
                if (cdata) {
                    if (c != ']' || !this.checkString(n, endCDATA)) continue;
                    n += endCDATA.length() - 1;
                    cdata = false;
                    continue;
                }
                if (c == '<') {
                    if (this.checkString(n, COMMENT)) {
                        escapes = true;
                        n = this.commentEnd(n + COMMENT.length()) - 1;
                        continue;
                    }
                    if (this.checkString(n, CDATA)) {
                        cdata = true;
                        escapes = true;
                        continue;
                    }
                    String string = escapes ? this.processEscapes(this.offset, n) : this.document.substring(this.offset, n);
                    this.offset = n;
                    return string;
                }
                if (c != '&') continue;
                escape = true;
                escapes = true;
            }
        } while (this.getLine());
        return escapes ? this.processEscapes(this.offset, this.length) : this.document.substring(this.offset, this.length);
    }

    public String processEscapes(int from, int to) throws XmlException {
        StringBuilder builder = new StringBuilder(to - from);
        for (int n = from; n < to; ++n) {
            char c = this.document.charAt(n);
            if (c == '&') {
                if (this.checkString(n, "&lt;")) {
                    builder.append('<');
                } else if (this.checkString(n, "&gt;")) {
                    builder.append('>');
                } else if (this.checkString(n, "&quote;")) {
                    builder.append('\"');
                } else if (this.checkString(n, "&quot;")) {
                    builder.append('\"');
                } else if (this.checkString(n, "&apos;")) {
                    builder.append('\'');
                } else if (this.checkString(n, "&amp;")) {
                    builder.append('&');
                } else if (this.checkString(n, "&nbsp;")) {
                    builder.append(' ');
                } else {
                    this.print("Bad excape: ", n, 50);
                    throw new XmlException("invalid escape seqeuence");
                }
                while (this.document.charAt(n) != ';') {
                    ++n;
                }
                continue;
            }
            if (c == '<') {
                if (this.checkString(n, CDATA)) {
                    n += CDATA.length();
                    while ((c = this.document.charAt(n)) != ']' || !this.checkString(n, endCDATA)) {
                        builder.append(c);
                        ++n;
                    }
                    n += endCDATA.length() - 1;
                    continue;
                }
                if (!this.checkString(n, COMMENT)) continue;
                n += this.commentEnd(n + COMMENT.length()) - 1;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public void skipWhite() {
        boolean comment = false;
        while (this.offset < this.length) {
            char c = this.document.charAt(this.offset);
            if (comment) {
                if (c == '-' && this.checkString(this.offset, endCOMMENT)) {
                    comment = false;
                    this.offset += 2;
                }
            } else {
                if (c == '<' && this.checkString(this.offset, COMMENT)) {
                    comment = true;
                    this.offset += 3;
                }
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            }
            ++this.offset;
        }
    }

    public boolean checkComment() {
        if (!this.checkString(this.offset, COMMENT)) {
            return false;
        }
        this.offset += 4;
        this.skipComment();
        return true;
    }

    public int commentEnd(int start) {
        for (int n = start; n < this.length; ++n) {
            if (this.document.charAt(n) != '-' || !this.checkString(n, endCOMMENT)) continue;
            return n + endCOMMENT.length();
        }
        return this.length;
    }

    public void skipComment() {
        while (this.offset < this.length) {
            char c = this.document.charAt(this.offset);
            if (c == '-' && this.checkString(this.offset, endCOMMENT)) {
                this.offset += 2;
                break;
            }
            ++this.offset;
        }
    }

    public boolean checkString(int offset, String string) {
        int l = string.length();
        if (offset + l > this.length) {
            return false;
        }
        for (int n = 0; n < l; ++n) {
            if (this.document.charAt(offset + n) == string.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public String getToken() throws XmlException {
        while (this.offset >= this.length && this.inputStream != null) {
            this.getLine();
        }
        char quote = this.getChar();
        boolean hasEscape = false;
        do {
            char c;
            int n;
            if (quote == '\"' || quote == '\'') {
                for (n = ++this.offset; n < this.length; ++n) {
                    c = this.document.charAt(n);
                    if (c == quote) {
                        String token = hasEscape ? this.getString(this.offset, n) : this.document.substring(this.offset, n);
                        this.offset = n + 1;
                        return token;
                    }
                    if (c != '&') continue;
                    hasEscape = true;
                }
            } else {
                for (n = this.offset; n < this.length; ++n) {
                    c = this.document.charAt(n);
                    if ((n <= this.offset || c != '/') && c != '=' && c != '>' && c != ' ' && c != '\t' && c != '\n' && c != '\r') continue;
                    String token = this.document.substring(this.offset, n);
                    this.offset = n;
                    return token;
                }
            }
        } while (this.getLine());
        throw new XmlException("unterminated xml token");
    }

    private boolean getLine() {
        if (this.inputStream == null) {
            return false;
        }
        try {
            String line = this.inputStream.readLine();
            if (line == null) {
                return false;
            }
            this.document.append(line);
            this.length = this.document.length();
        }
        catch (IOException exception) {
            this.inputStream = null;
            return false;
        }
        return true;
    }

    public String getTail() {
        if (this.length >= this.offset) {
            return "<end of string>";
        }
        return this.document.substring(this.offset);
    }

    boolean startsWith(String substring, int offset) {
        int pos = this.document.indexOf(substring, offset);
        return pos == offset;
    }

    public String getString(int offset, int end) throws XmlException {
        StringBuilder builder = new StringBuilder();
        boolean skip = false;
        int n = offset;
        while (n < end) {
            char c;
            if ((c = this.document.charAt(n++)) == '&') {
                if (this.startsWith("amp;", n)) {
                    builder.append('&');
                } else if (this.startsWith("apos;", n)) {
                    builder.append('\'');
                } else if (this.startsWith("quot;", n)) {
                    builder.append('\"');
                } else if (this.startsWith("lt;", n)) {
                    builder.append('<');
                } else if (this.startsWith("gt;", n)) {
                    builder.append('>');
                } else {
                    throw new XmlException("bad xml escape sequence");
                }
                skip = true;
                continue;
            }
            if (!skip) {
                builder.append(c);
                continue;
            }
            if (c != ';') continue;
            skip = false;
        }
        return builder.toString();
    }
}

