/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

public enum LengthUnit {
    BYTES(1L, "B"),
    KILOBYTES(BYTES.getFactor() * 1024L, "KB"),
    MEGABYTES(KILOBYTES.getFactor() * 1024L, "MB"),
    GIGABYTES(MEGABYTES.getFactor() * 1024L, "GB"),
    TERABYTES(GIGABYTES.getFactor() * 1024L, "TB");

    private final long factor;
    private final String code;

    private LengthUnit(long factor, String unitCode) {
        this.factor = factor;
        this.code = unitCode;
    }

    public long toBytes(long length) {
        return this.convert(length, BYTES);
    }

    public long toKilobytes(long length) {
        return this.convert(length, KILOBYTES);
    }

    public long toMegabytes(long length) {
        return this.convert(length, MEGABYTES);
    }

    public long toGigabytes(long length) {
        return this.convert(length, GIGABYTES);
    }

    public long toTerabytes(long length) {
        return this.convert(length, TERABYTES);
    }

    public long convert(long length, LengthUnit to) {
        return LengthUnit.convert(length, this, to);
    }

    private static long convert(long length, LengthUnit from, LengthUnit to) {
        long toScale;
        long fromScale = from.getFactor();
        return fromScale > (toScale = to.getFactor()) ? length / fromScale * toScale : length * fromScale / toScale;
    }

    public long getFactor() {
        return this.factor;
    }

    public String getCode() {
        return this.code;
    }

    public static LengthUnit getBestLengthUnit(long length) {
        long absLength = Math.abs(length);
        LengthUnit bestLengthUnit = BYTES;
        for (LengthUnit lengthUnit : LengthUnit.values()) {
            if (lengthUnit.getFactor() > absLength) break;
            bestLengthUnit = lengthUnit;
        }
        return bestLengthUnit;
    }
}

