/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.stats.metrics.Metric;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;

public class MetricImpl
implements Metric {
    private String region;
    private String host;
    private String type;
    private String metric;
    private String db;

    public MetricImpl(String region, String host, String type, String metric, String db) {
        this.region = region;
        this.host = host;
        this.type = type;
        this.metric = metric;
        this.db = db;
    }

    public MetricImpl(String region, String host, String type, String metric) {
        this(region, host, type, metric, null);
    }

    public MetricImpl(Tag tag) throws XmlException {
        Preconditions.checkArgument("Metric".equals(tag.getName()), "not a Metric tag: %s", tag);
        this.region = tag.getAttribute("Region", null);
        this.host = tag.getAttribute("Host", null);
        this.type = tag.getAttribute("Type", null);
        this.metric = tag.getAttribute("Metric", null);
        this.db = tag.getAttribute("Database", null);
        this.validate();
    }

    @Override
    public Metric encode(Tag element) {
        this.validate();
        if (this.region != null) {
            element.addAttribute("Region", this.region);
        }
        if (this.host != null) {
            element.addAttribute("Host", this.host);
        }
        if (this.type != null) {
            element.addAttribute("Type", this.type);
        }
        if (this.metric != null) {
            element.addAttribute("Metric", this.metric);
        }
        if (this.db != null) {
            element.addAttribute("Database", this.db);
        }
        return this;
    }

    @Override
    public Tag toTag() {
        Tag tag = TagFactory.createTag("Metric");
        this.encode(tag);
        return tag;
    }

    @Override
    public String getName() {
        return this.metric;
    }

    @Override
    public Metric setName(String metric) {
        this.metric = metric;
        return this;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public Metric setRegion(String region) {
        this.region = region;
        return this;
    }

    @Override
    public String getNode() {
        return this.host;
    }

    @Override
    public Metric setNode(String host) {
        this.host = host;
        return this;
    }

    @Override
    public String getNodeType() {
        return this.type;
    }

    @Override
    public Metric setNodeType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public Metric setDb(String db) {
        this.db = db;
        return this;
    }

    @Override
    public boolean hasDb() {
        return this.db != null;
    }

    public String toString() {
        return String.format("Metric[%s, %s, %s, %s, %s]", this.region, this.host, this.type, this.metric, this.db);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetricImpl)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MetricImpl m = (MetricImpl)o;
        return StringUtils.equals(this.region, m.region) && StringUtils.equals(this.host, m.host) && StringUtils.equals(this.type, m.type) && StringUtils.equals(this.metric, m.metric) && StringUtils.equals(this.db, m.db);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.metric == null ? 0 : this.metric.hashCode());
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        return result;
    }

    public MetricImpl validate() {
        Preconditions.checkArgument(this.region != null || this.host != null || this.type != null || this.metric != null || this.db != null, "metric must have at least one field that is not null/wildcard");
        return this;
    }
}

