/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.ArrayList;
import java.util.HashMap;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.TransformParams;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UR3TransferParam
extends Dictionary
implements TransformParams {
    public static final Name DOCUMENT_KEY = new Name("Document");
    public static final Name VERSION_DEFAULT_VALUE = new Name("2.2");
    public static final Name MSG_KEY = new Name("Msg");
    public static final Name ANNOTATION_KEY = new Name("Annots");
    public static final Name ANNOTATION_VALUE_CREATE = new Name("Create");
    public static final Name ANNOTATION_VALUE_DELETE = new Name("Delete");
    public static final Name ANNOTATION_VALUE_MODIFY = new Name("Modify");
    public static final Name ANNOTATION_VALUE_COPY = new Name("Copy");
    public static final Name ANNOTATION_VALUE_IMPORT = new Name("Import");
    public static final Name ANNOTATION_VALUE_EXPORT = new Name("Export");
    public static final Name ANNOTATION_VALUE_ONLINE = new Name("Online");
    public static final Name ANNOTATION_VALUE_SUMMARY_VIEW = new Name("SummaryView");
    public static final Name FORM_KEY = new Name("Form");
    public static final Name FORM_VALUE_ADD = new Name("Add");
    public static final Name FORM_VALUE_DELETE = new Name("Delete");
    public static final Name FORM_VALUE_FILL_IN = new Name("FillIn");
    public static final Name FORM_VALUE_IMPORT = new Name("Import");
    public static final Name FORM_VALUE_EXPORT = new Name("Export");
    public static final Name FORM_VALUE_SUBMIT_STANDALONE = new Name("SubmitStandalone");
    public static final Name FORM_VALUE_SPAWN_TEMPLATE = new Name("SpawnTemplate");
    public static final Name FORM_VALUE_BARCODE_PLAIN_TEXT = new Name("BarcodePlainText");
    public static final Name FORM_VALUE_ONLINE = new Name("Online");
    public static final Name SIGNATURE_KEY = new Name("Signature");
    public static final Name SIGNATURE_VALUE_MODIFY = new Name("Modify");
    public static final Name EMBEDDED_FILES_KEY = new Name("EF");
    public static final Name EMBEDDED_FILES_VALUE_CREATE = new Name("Create");
    public static final Name EMBEDDED_FILES_VALUE_DELETE = new Name("Delete");
    public static final Name EMBEDDED_FILES_VALUE_MODIFY = new Name("Modify");
    public static final Name EMBEDDED_FILES_VALUE_IMPORT = new Name("Import");
    public static final Name PERMISSION_KEY = new Name("P");

    public UR3TransferParam(Library library, HashMap entries) {
        super(library, entries);
    }

    public ArrayList<Name> getDocumentRights() {
        return (ArrayList)this.library.getArray(this.entries, DOCUMENT_KEY);
    }

    public String getMsg() {
        Object value = this.library.getObject(this.entries, MSG_KEY);
        if (value != null && value instanceof StringObject) {
            StringObject text = (StringObject)value;
            return Utils.convertStringObject(this.library, text);
        }
        return null;
    }

    public Name getVersion() {
        return this.library.getName(this.entries, VERSION_KEY);
    }

    public ArrayList<Name> getAnnotationRights() {
        return (ArrayList)this.library.getArray(this.entries, ANNOTATION_KEY);
    }

    public ArrayList<Name> getFormRights() {
        return (ArrayList)this.library.getArray(this.entries, FORM_KEY);
    }

    public ArrayList<Name> getSignatureRights() {
        return (ArrayList)this.library.getArray(this.entries, SIGNATURE_KEY);
    }

    public ArrayList<Name> getEmbeddedFilesRights() {
        return (ArrayList)this.library.getArray(this.entries, EMBEDDED_FILES_KEY);
    }

    public boolean getPermission() {
        return this.library.getBoolean(this.entries, PERMISSION_KEY);
    }
}

