/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingPort;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IFloatingDockingPort;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class FloatingDockingPort
extends DockingPort
implements IFloatingDockingPort {
    private static final long serialVersionUID = -8638759130060755602L;
    protected Window floatingWindow;

    public FloatingDockingPort() {
        this.setTabsAsDragSourceEnabled(true);
        this.setSingleTabAllowed(UIManager.getBoolean("JYDocking.floatingWindow.singleTabAllowed"));
    }

    public void setFloatingWindow(Window window) {
        this.floatingWindow = window;
    }

    public void undockingCompleted(DockingEvent dockingEvent) {
        super.undockingCompleted(dockingEvent);
        if (dockingEvent.getOldDockingPort() == this && this.getDockableCount() == 0) {
            if (this.floatingWindow instanceof FloatingDialog) {
                ((FloatingDialog)this.floatingWindow).destroy();
            } else if (this.floatingWindow instanceof FloatingFrame) {
                ((FloatingFrame)this.floatingWindow).destroy();
            }
            this.floatingWindow = null;
        }
    }

    public int getDockableCount() {
        JComponent jComponent = this.getDockedComponent();
        if (jComponent instanceof JTabbedPane) {
            return ((JTabbedPane)jComponent).getTabCount();
        }
        return this.countDockables(this, 0);
    }

    private int countDockables(Container container, int n) {
        Component[] componentArray = container.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component instanceof IDockable) {
                ++n;
            }
            if (component instanceof Container) {
                n = this.countDockables((Container)component, n);
            }
            ++n3;
        }
        return n;
    }
}

