/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDragPreview;
import de.javasoft.swing.jydocking.IRegionChecker;
import de.javasoft.swing.jydocking.RegionChecker;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DragPreview
implements IDragPreview {
    private static final int DEFAULT_TAB_WIDTH = 50;
    private static final int DEFAULT_TAB_HEIGHT = 20;

    DragPreview() {
    }

    @Override
    public abstract void drawPreview(Graphics2D var1, Polygon var2, IDockable var3, Map<Object, Object> var4);

    @Override
    public Polygon createPreviewPolygon(Component component, IDockingPort iDockingPort, IDockable iDockable, String string, Component component2, Map<Object, Object> map) {
        if (component == null || iDockingPort == null || string == null || component2 == null) {
            return null;
        }
        if ("UNKNOWN".equals(string)) {
            return null;
        }
        if (iDockable == null) {
            Rectangle rectangle = iDockingPort.getComponent().getBounds();
            rectangle = SwingUtilities.convertRectangle(iDockingPort.getComponent().getParent(), rectangle, component2);
            return this.createPolyRect(rectangle);
        }
        Polygon polygon = null;
        JComponent jComponent = iDockable.getComponent();
        if (this.isOuterRegion(string)) {
            polygon = this.createPolyRect(iDockingPort, jComponent, string);
        } else {
            int n = -1;
            if (map != null && map.get("DROP_TAB_INDEX") != null) {
                n = (Integer)map.get("DROP_TAB_INDEX");
            }
            polygon = this.createPolyTab(iDockingPort, jComponent, n);
            jComponent = iDockingPort.getComponent();
        }
        this.translate(jComponent, polygon, component2);
        return polygon;
    }

    private void translate(Component component, Polygon polygon, Component component2) {
        if (component == null || polygon == null || component2 == null) {
            return;
        }
        Rectangle rectangle = component.getBounds();
        rectangle.setLocation(0, 0);
        Rectangle rectangle2 = SwingUtilities.convertRectangle(component, rectangle, component2);
        int n = rectangle2.x - rectangle.x;
        int n2 = rectangle2.y - rectangle.y;
        int n3 = polygon.npoints;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4;
            polygon.xpoints[n5] = polygon.xpoints[n5] + n;
            int n6 = n4++;
            polygon.ypoints[n6] = polygon.ypoints[n6] + n2;
        }
    }

    protected Polygon createPolyRect(IDockingPort iDockingPort, Component component, String string) {
        IRegionChecker iRegionChecker = iDockingPort.getRegionChecker();
        if (iRegionChecker == null) {
            iRegionChecker = new RegionChecker();
        }
        Rectangle rectangle = iRegionChecker.getSiblingBounds(component, string);
        return this.createPolyRect(rectangle);
    }

    protected Polygon createPolyRect(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int[] nArray = new int[]{rectangle.x, n, n, rectangle.x};
        int[] nArray2 = new int[]{rectangle.y, rectangle.y, n2, n2};
        return new Polygon(nArray, nArray2, 4);
    }

    protected Polygon createPolyTab(IDockingPort iDockingPort, Component component, int n) {
        boolean bl;
        JComponent jComponent = iDockingPort.getDockedComponent();
        Rectangle rectangle = this.createTabbedPaneRect(iDockingPort, component);
        if (jComponent == null && iDockingPort.isSingleTabAllowed() == Boolean.FALSE.booleanValue()) {
            return this.createPolyRect(rectangle);
        }
        Boolean bl2 = (Boolean)iDockingPort.getComponent().getClientProperty("JYDocking.tabDragPreview");
        if (bl2 == Boolean.FALSE) {
            return this.createPolyRect(rectangle);
        }
        if (n >= 0 && jComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            return this.createPolyRect(jTabbedPane.getBoundsAt(n));
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 50, 20);
        boolean bl3 = bl = iDockingPort.getTabPlacement() == 1;
        if (jComponent instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            Rectangle rectangle3 = jTabbedPane.getBoundsAt(jTabbedPane.getTabCount() - 1);
            rectangle2.height = rectangle3.height;
            rectangle2.y = rectangle3.y;
            rectangle2.x = rectangle3.x + rectangle3.width;
            bl = jTabbedPane.getTabPlacement() == 1;
        } else {
            int n2 = rectangle2.y = bl ? 0 : rectangle.height - 20;
            if (jComponent != null) {
                rectangle2.x += 50;
            }
        }
        rectangle.height -= rectangle2.height;
        if (bl) {
            rectangle.y += rectangle2.height;
        }
        if (bl) {
            return this.createPolyTabOnTop(rectangle, rectangle2);
        }
        return this.createPolyTabOnBottom(rectangle, rectangle2);
    }

    protected Rectangle createTabbedPaneRect(IDockingPort iDockingPort, Component component) {
        Rectangle rectangle = iDockingPort.getComponent().getBounds();
        rectangle.setLocation(0, 0);
        return rectangle;
    }

    protected Polygon createPolyTabOnTop(Rectangle rectangle, Rectangle rectangle2) {
        Polygon polygon = new Polygon();
        int n = rectangle2.x + rectangle2.width;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        if (rectangle2.x != 0) {
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon.addPoint(rectangle2.x, rectangle.y);
        }
        polygon.addPoint(rectangle2.x, rectangle2.y);
        polygon.addPoint(n, rectangle2.y);
        polygon.addPoint(n, rectangle.y);
        polygon.addPoint(n2, rectangle.y);
        polygon.addPoint(n2, n3);
        polygon.addPoint(rectangle.x, n3);
        return polygon;
    }

    protected Polygon createPolyTabOnBottom(Rectangle rectangle, Rectangle rectangle2) {
        Polygon polygon = new Polygon();
        int n = rectangle2.x + rectangle2.width;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        int n4 = n3 + rectangle2.height;
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(n2, rectangle.y);
        polygon.addPoint(n2, n3);
        polygon.addPoint(n, n3);
        polygon.addPoint(n, n4);
        polygon.addPoint(rectangle2.x, n4);
        if (rectangle2.x != 0) {
            polygon.addPoint(rectangle2.x, n3);
            polygon.addPoint(rectangle.x, n3);
        }
        return polygon;
    }

    protected boolean isOuterRegion(String string) {
        return "NORTH".equals(string) || "SOUTH".equals(string) || "EAST".equals(string) || "WEST".equals(string);
    }

    protected void drawPolygon(Graphics2D graphics2D, Polygon polygon, int n) {
        Polygon polygon2 = this.clonePolygon(polygon);
        Point point = this.getCenterOfGravity(polygon2);
        int n2 = 0;
        while (n2 < n) {
            graphics2D.drawPolygon(polygon2);
            this.gravitate(polygon2, point, 1);
            ++n2;
        }
    }

    private Polygon clonePolygon(Polygon polygon) {
        return new Polygon((int[])polygon.xpoints.clone(), (int[])polygon.ypoints.clone(), polygon.npoints);
    }

    private void gravitate(Polygon polygon, Point point, int n) {
        int n2 = polygon.npoints;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = point.x > polygon.xpoints[n3] ? n : -n;
            int n5 = point.y > polygon.ypoints[n3] ? n : -n;
            int n6 = n3;
            polygon.xpoints[n6] = polygon.xpoints[n6] + n4;
            int n7 = n3++;
            polygon.ypoints[n7] = polygon.ypoints[n7] + n5;
        }
    }

    private Point getCenterOfGravity(Polygon polygon) {
        int n = 0;
        int n2 = 0;
        int n3 = polygon.npoints;
        int n4 = 0;
        while (n4 < n3) {
            n += polygon.xpoints[n4];
            n2 += polygon.ypoints[n4];
            ++n4;
        }
        return new Point(n / n3, n2 / n3);
    }
}

