/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.runtime.installer.config.Bitness;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicationRegistryImpl {
    public static boolean checkApplicationId(File dir) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String oldApplicationId = InstallerUtil.getOldApplicationId(dir);
        String targetAppId = installerConfig.getTargetApplicationId();
        if (!installerConfig.isAddOnInstaller()) {
            return oldApplicationId == null || oldApplicationId.trim().length() == 0 || Objects.equals(oldApplicationId, targetAppId);
        }
        if (oldApplicationId == null) {
            return false;
        }
        return Objects.equals(oldApplicationId, targetAppId);
    }

    public static boolean isUpdateDirectory(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return false;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String oldApplicationId = InstallerUtil.getOldApplicationId(dir);
        String myApplicationId = installerConfig.getApplicationId();
        return Objects.equals(oldApplicationId, myApplicationId);
    }

    public static ApplicationRegistry.ApplicationInfo[] getApplicationInfoById(String id) {
        String[] dirPaths;
        ArrayList<ApplicationInfoImpl> ret = new ArrayList<ApplicationInfoImpl>();
        for (String dirPath : dirPaths = InstallRegistry.getAllInstallationDirs(id, true)) {
            File appDir;
            String singleBundleName;
            ApplicationInfoImpl applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(new File(dirPath));
            if (applicationInfo != null && Objects.equals(id, applicationInfo.getId())) {
                ret.add(applicationInfo);
            }
            if (!Util.isMacOS() || (singleBundleName = InstallRegistry.getSingleBundleName(id, dirPath)) == null || (applicationInfo = ApplicationRegistryImpl.getApplicationInfoByDir(appDir = new File(dirPath, singleBundleName + "/" + "Contents/Resources/app"))) == null || !Objects.equals(id, applicationInfo.getId())) continue;
            ret.add(applicationInfo);
        }
        return ret.toArray(new ApplicationRegistry.ApplicationInfo[0]);
    }

    public static ApplicationInfoImpl getApplicationInfoByDir(File dir) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(dir);
        if (installerConfig == null) {
            return null;
        }
        return new ApplicationInfoImpl(dir, installerConfig);
    }

    public static ApplicationRegistry.ApplicationInfo[] getAddOnApplicationInfoByDir(File dir) {
        List<InstallerConfig> addOnConfigs = InstallerUtil.getAddOnApplicationConfigs(dir);
        if (addOnConfigs == null) {
            return null;
        }
        ApplicationRegistry.ApplicationInfo[] ret = new ApplicationRegistry.ApplicationInfo[addOnConfigs.size()];
        for (int i = 0; i < addOnConfigs.size(); ++i) {
            ret[i] = new ApplicationInfoImpl(dir, addOnConfigs.get(i));
        }
        return ret;
    }

    public static class ApplicationInfoImpl
    implements ApplicationRegistry.ApplicationInfo {
        private File installationDirectory;
        private String id;
        private String name;
        private String version;
        private String mediaSetId;
        private Bitness bitness;

        public ApplicationInfoImpl(File installationDirectory, InstallerConfig installerConfig) {
            this.id = installerConfig.getApplicationId();
            this.name = installerConfig.getApplicationName();
            this.version = installerConfig.getApplicationVersion();
            this.mediaSetId = installerConfig.getMediaSetId();
            this.bitness = installerConfig.getBitness();
            this.installationDirectory = installationDirectory;
        }

        @Override
        public String getMediaSetId() {
            return this.mediaSetId;
        }

        @Override
        public File getInstallationDirectory() {
            return this.installationDirectory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        public Bitness getBitness() {
            return this.bitness;
        }

        public String toString() {
            return "ApplicationInfo: " + this.getName() + " " + this.getVersion() + " (id: " + this.getId() + "), dir: " + this.getInstallationDirectory();
        }
    }
}

