/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.ejt.framework.CommonApplicationServices;
import com.install4j.runtime.filechooser.CustomFileChooser;
import com.install4j.runtime.filechooser.FileAccessMode;
import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.FileChooserQuestion;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.filechooser.SwingFileChooserHelper;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

class SwingFileChooser
extends FileChooser {
    private CustomFileChooser fileChooser;
    private Map<FileChooserQuestion, JCheckBox> checkboxes = new HashMap<FileChooserQuestion, JCheckBox>();

    SwingFileChooser() {
    }

    @Override
    public boolean selectInternal() {
        int result;
        this.fileChooser = new CustomFileChooser();
        Collection<FileChooserQuestion> fileChooserQuestions = this.getFileChooserQuestions();
        if (fileChooserQuestions.size() > 0) {
            JPanel accessory = CustomFileChooser.createLowerAccessoryPanel();
            for (FileChooserQuestion fileChooserQuestion : fileChooserQuestions) {
                JCheckBox checkbox = new JCheckBox(fileChooserQuestion.getDescription(), fileChooserQuestion.isSelected());
                accessory.add(checkbox);
                this.checkboxes.put(fileChooserQuestion, checkbox);
            }
            this.fileChooser.setLowerAccessory(accessory);
        }
        SwingFileChooserHelper.configure(this, this.fileChooser);
        this.fileChooser.resetChoosableFileFilters();
        for (MultiFileFilter fileFilter : this.getFileFilters()) {
            this.fileChooser.addChoosableFileFilter(fileFilter);
        }
        FileFilter selectedFileFilter = this.getSelectedFileFilter();
        if (selectedFileFilter == null) {
            selectedFileFilter = this.getFileFilters().size() > 0 ? (FileFilter)this.getFileFilters().iterator().next() : this.fileChooser.getAcceptAllFileFilter();
        }
        this.fileChooser.setFileFilter(selectedFileFilter);
        this.fileChooser.setDialogType(this.getDialogType());
        this.fileChooser.setMultiSelectionEnabled(this.isMultiple());
        while ((result = this.fileChooser.showDialog(this.getParent(), this.getApproveButtonText())) == 0 && this.getFileAccessMode() == FileAccessMode.SAVE && this.fileChooser.getSelectedFile().exists() && !CommonApplicationServices.getInstance().confirmOverwrite(this.getParent(), this.fileChooser.getSelectedFile())) {
        }
        for (Map.Entry<FileChooserQuestion, JCheckBox> entry : this.checkboxes.entrySet()) {
            entry.getKey().setSelected(entry.getValue().isSelected());
        }
        return result == 0;
    }

    @Override
    protected Collection<File> getSelectedFilesInternal() {
        if (this.isMultiple()) {
            return Arrays.asList(this.fileChooser.getSelectedFiles());
        }
        return Collections.singleton(this.fileChooser.getSelectedFile());
    }

    private int getDialogType() {
        FileAccessMode fileAccessMode = this.getFileAccessMode();
        switch (fileAccessMode) {
            case OPEN: {
                return 0;
            }
            case SAVE: {
                return 1;
            }
        }
        throw new RuntimeException(String.valueOf((Object)fileAccessMode));
    }
}

