/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.ComponentCheckBox;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentToggleButton;
import com.install4j.runtime.beans.screens.componentselection.ComponentTree;
import com.install4j.runtime.beans.screens.componentselection.DescriptionModeProvider;
import com.install4j.runtime.beans.screens.componentselection.IndeterminateStateDisplay;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.DisplayTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ComponentCellHandler
extends JPanel
implements TreeCellRenderer,
TreeCellEditor,
ActionListener {
    private static final Icon ICON_HELP = GUIHelper.loadIcon("help_14.png");
    private static final int CHECKBOX_WIDTH = new JCheckBox().getPreferredSize().width;
    private static final int SCROLL_BAR_WIDTH = new JScrollBar((int)1).getPreferredSize().width;
    private ComponentTree tree;
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private JToggleButton chkSelected;
    private JToggleButton chkSelectedDisabled;
    private DefaultTreeCellRenderer defaultRenderer;
    private ComponentToggleButton btnHelp;
    private DisplayTextArea dtxaDescription;
    private ComponentNode editedComponentNode;
    private boolean pathBoundCheck = false;
    private int dtxaInset;
    private ComponentNodeConfig lastConfig;

    public ComponentCellHandler(ComponentTree tree) {
        this.tree = tree;
        this.setupControls();
        this.setupComponents();
        this.setupEventHandlers();
        this.applyComponentOrientation(tree.getComponentOrientation());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.chkSelected) {
            this.editedComponentNode.setSelected(this.chkSelected.isSelected(), true);
            this.tree.nodeToggled();
            this.tree.stopEditing();
            this.tree.startEditingAtPath(new TreePath(this.editedComponentNode.getPath()));
        } else if (source == this.btnHelp) {
            this.editedComponentNode.setDisplayDescription(this.btnHelp.isSelected());
        }
    }

    public ComponentTree getTree() {
        return this.tree;
    }

    private void setupControls() {
        this.chkSelected = this.createSelectionToggleButton();
        this.chkSelectedDisabled = this.createSelectionToggleButton();
        this.chkSelectedDisabled.setEnabled(false);
        this.defaultRenderer = new DefaultTreeCellRenderer();
        this.customizeDefaultRenderer(this.defaultRenderer);
        this.btnHelp = new ComponentToggleButton(ICON_HELP);
        this.dtxaDescription = new DisplayTextArea();
        Font font = this.dtxaDescription.getFont();
        DescriptionModeProvider descriptionModeProvider = this.tree.getDescriptionModeProvider();
        int style = 0;
        float size = font.getSize2D();
        if (descriptionModeProvider.isBoldDescription()) {
            ++style;
        }
        if (descriptionModeProvider.isItalicDescription()) {
            style += 2;
        }
        if (descriptionModeProvider.isSmallerDescription()) {
            size -= 1.0f;
        }
        font = font.deriveFont(style, size);
        this.dtxaDescription.setFont(font);
    }

    protected void customizeDefaultRenderer(DefaultTreeCellRenderer defaultRenderer) {
    }

    protected JToggleButton createSelectionToggleButton() {
        return new ComponentCheckBox();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    private void setupComponents() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weighty = 0.0;
        gc.anchor = 21;
        this.add((Component)this.chkSelected, gc);
        gc.gridx = 1;
        this.add((Component)this.chkSelectedDisabled, gc);
        gc.gridx = 2;
        gc.fill = 0;
        this.add((Component)this.defaultRenderer, gc);
        gc.gridx = 3;
        gc.weightx = 0.0;
        gc.fill = 0;
        this.add((Component)this.btnHelp, gc);
        gc.gridy = 1;
        gc.gridx = 2;
        gc.gridwidth = 3;
        gc.fill = 2;
        gc.weightx = 1.0;
        this.dtxaInset = this.tree.getLeafIconWidth() + this.defaultRenderer.getIconTextGap();
        gc.insets.left += this.dtxaInset;
        this.add((Component)this.dtxaDescription, gc);
        gc.insets.left -= this.dtxaInset;
        this.defaultRenderer.setOpenIcon(GUIHelper.ICON_FOLDER_OPEN);
        this.defaultRenderer.setClosedIcon(GUIHelper.ICON_FOLDER_CLOSED);
    }

    private void setupEventHandlers() {
        this.chkSelected.addActionListener(this);
        this.btnHelp.addActionListener(this);
        ComponentTreeKeyHandler keyHandler = new ComponentTreeKeyHandler();
        this.chkSelected.addKeyListener(keyHandler);
        this.defaultRenderer.addKeyListener(keyHandler);
        this.addKeyListener(keyHandler);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree treeUnused, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ComponentNode componentNode = (ComponentNode)value;
        this.lastConfig = componentNode.getComponentNodeConfig();
        if (this.lastConfig != null && !this.pathBoundCheck) {
            boolean changeable = componentNode.isChangeable();
            this.chkSelected.setVisible(changeable);
            this.chkSelectedDisabled.setVisible(!changeable);
            JToggleButton toggleButton = changeable ? this.chkSelected : this.chkSelectedDisabled;
            toggleButton.setSelected(this.lastConfig.isSelected());
            if (toggleButton instanceof IndeterminateStateDisplay && this.isPartiallySelected(componentNode)) {
                ((IndeterminateStateDisplay)((Object)toggleButton)).setIndeterminate(true);
            }
            String description = this.lastConfig.getDescription().trim();
            boolean helpButtonVisible = this.isHelpButtonVisible(this.lastConfig);
            this.btnHelp.setVisible(helpButtonVisible);
            if (description.length() > 0) {
                this.prepareDescriptionDisplay(this.lastConfig, description, this.tree, row);
            } else {
                this.dtxaDescription.setVisible(false);
            }
            this.defaultRenderer.setLeafIcon(this.tree.getLeafIcon(this.lastConfig));
            this.defaultRenderer.getTreeCellRendererComponent(this.tree, this.lastConfig.getName(), selected, expanded, leaf, row, hasFocus);
            this.invalidate();
            this.validate();
        }
        return this;
    }

    protected boolean isHelpButtonVisible(ComponentNodeConfig config) {
        return config.getDescription().trim().length() > 0 && (!config.isHideHelpButton() || !config.isInitialDisplayDescription());
    }

    private boolean isPartiallySelected(ComponentNode componentNode) {
        return componentNode instanceof ComponentFolderNode && this.lastConfig.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareDescriptionDisplay(ComponentNodeConfig componentNodeConfig, String description, JTree tree, int row) {
        boolean displayDescription = componentNodeConfig.isDisplayDescription();
        this.btnHelp.setSelected(displayDescription);
        this.dtxaDescription.setVisible(displayDescription);
        if (displayDescription) {
            this.dtxaDescription.setText(description);
            Container parent = tree.getParent();
            if (parent == null) return;
            int parentWidth = parent.getParent().getWidth();
            TreePath path = tree.getPathForRow(row);
            if (path == null) return;
            this.pathBoundCheck = true;
            try {
                Rectangle pathBounds = tree.getPathBounds(path);
                if (pathBounds == null) return;
                int mainWidth = this.getComponentOrientation().isLeftToRight() ? parentWidth - pathBounds.x : pathBounds.x + pathBounds.width;
                int width = mainWidth - this.dtxaInset - CHECKBOX_WIDTH - 5 - SCROLL_BAR_WIDTH;
                Dimension size = new Dimension(width, 20);
                this.dtxaDescription.setPreferredSize(null);
                this.dtxaDescription.setSize(size);
                this.dtxaDescription.setPreferredSize(this.dtxaDescription.getPreferredSize());
                return;
            }
            finally {
                this.pathBoundCheck = false;
            }
        } else {
            this.dtxaDescription.setText("");
        }
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        ComponentCellHandler handler = this.copy();
        handler.editedComponentNode = (ComponentNode)value;
        TreePath selectionPath = tree.getSelectionPath();
        handler.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, selectionPath != null && selectionPath.getLastPathComponent() == value);
        handler.chkSelected.requestFocus();
        return handler;
    }

    protected ComponentCellHandler copy() {
        return new ComponentCellHandler(this.tree);
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners) {
            listener.editingCanceled(event);
        }
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener listener : this.listeners) {
            listener.editingStopped(event);
        }
        return true;
    }

    public boolean isPointInLabel(Point point) {
        return this.defaultRenderer.getBounds().contains(point);
    }

    private boolean isPointInHelpButton(Point point) {
        return this.btnHelp.isVisible() && this.btnHelp.getBounds().contains(point);
    }

    private boolean isPointInIcon(Point point) {
        return this.isPointInLabel(point) && point.x - this.defaultRenderer.getX() < 16;
    }

    public String getToolTipText(Point point) {
        if (this.isPointInHelpButton(point)) {
            return this.btnHelp.isSelected() ? Messages.getMessages().getString("ComponentHideDescription") : Messages.getMessages().getString("ComponentShowDescription");
        }
        if (this.isPointInIcon(point)) {
            return this.tree.getIconTooltip(this.lastConfig);
        }
        return null;
    }

    private class ComponentTreeKeyHandler
    extends KeyAdapter {
        private ComponentTreeKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            ComponentCellHandler.this.tree.dispatchEvent(event);
        }
    }
}

