/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.runtime.beans.formcomponents.TextComponent;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class TextAreaComponent
extends TextComponent {
    private int columns = 0;
    private int rows = 3;
    private boolean fillVertical = false;
    private boolean lineWrap = true;
    private boolean wrapWordStyle = false;
    private boolean useLabelFont = false;

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isFillVertical() {
        return this.fillVertical;
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public boolean isLineWrap() {
        return this.lineWrap;
    }

    public void setLineWrap(boolean lineWrap) {
        this.lineWrap = lineWrap;
    }

    public boolean isWrapWordStyle() {
        return this.wrapWordStyle;
    }

    public void setWrapWordStyle(boolean wrapWordStyle) {
        this.wrapWordStyle = wrapWordStyle;
    }

    public boolean isUseLabelFont() {
        return this.useLabelFont;
    }

    public void setUseLabelFont(boolean useLabelFont) {
        this.useLabelFont = useLabelFont;
    }

    @Override
    public boolean isFillCenterVertical() {
        return this.fillVertical;
    }

    @Override
    public JComponent createCenterComponent() {
        JComponent centerComponent = super.createCenterComponent();
        JScrollPane scrollPane = new JScrollPane(centerComponent){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        scrollPane.setAlignmentX(0.0f);
        if (this.columns > 0) {
            JViewport viewport = scrollPane.getViewport();
            Dimension preferredSize = centerComponent.getPreferredSize();
            viewport.setMinimumSize(preferredSize);
            viewport.setMaximumSize(preferredSize);
        }
        return scrollPane;
    }

    @Override
    protected JTextComponent createTextComponent() {
        JTextArea textArea = new JTextArea(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        if (this.columns > 0) {
            textArea.setColumns(this.columns);
        }
        if (this.rows > 0) {
            textArea.setRows(this.rows);
        }
        textArea.setLineWrap(this.lineWrap);
        textArea.setWrapStyleWord(this.wrapWordStyle);
        return textArea;
    }

    @Override
    protected void applyTextComponentProperties(JTextComponent textComponent) {
        super.applyTextComponentProperties(textComponent);
        if (this.useLabelFont) {
            textComponent.setFont(UIManager.getFont("Label.font"));
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return this.columns == 0;
    }

    @Override
    public Class getConfigurationObjectClass() {
        return JTextArea.class;
    }

    @Override
    protected boolean isLeadingLabelTopAligned() {
        return true;
    }
}

