/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.services.ServiceAccount;
import com.install4j.runtime.beans.actions.services.WindowsPriority;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.AutoUninstallNotPerformedException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.util.VersionCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;

public class InstallServiceAction
extends SystemAutoUninstallInstallAction
implements PropertyLoggingInterceptor {
    public static final String SYSTEMCTL_PATH = "/bin/systemctl";
    public static final String SYSTEMCTL_NO_ASK_PASSWORD = "--no-ask-password";
    private static final String NAME_RESTART_MILLIS = "serviceRestartMillis";
    private static final String NAME_MAX_RESTARTS = "serviceMaxRestarts";
    private static final String NAME_RESET_SECONDS = "serviceResetSeconds";
    private String launcherId = "";
    private File executable;
    private String serviceName;
    private boolean autoStart = true;
    private String description = "";
    private String windowsDependencies = "";
    private String macosIdentifier = "";
    private String windowsArguments = "";
    private String windowsDisplayName = "";
    private boolean restartOnFailure;
    private boolean interactive;
    private boolean delayedAutoStart;
    private WindowsPriority windowsPriority = WindowsPriority.NORMAL_PRIORITY_CLASS;
    private ServiceAccount serviceAccount = ServiceAccount.LOCAL_SYSTEM;
    private String accountNameOrSid = "";
    private String password = "";
    private boolean keepCurrentAccount = false;
    private static final String PROP_SERVICE_PATH = "servicePath";
    private static final String PROP_SERVICE_NAME = "serviceName";
    private static final String PROP_STARTUP_TYPE = "startupType";
    private static final String PROP_IDENTIFIER = "identifier";
    private static final String STARTUP_ITEMS_FILE_NAME = "/Library/StartupItems";
    public static final String LAUNCH_DAEMONS_FILE_NAME = "/Library/LaunchDaemons";
    private static final String STARTUP_PARAMETERS_PLIST_NAME = "StartupParameters.plist";
    private static final String REGKEY_PRIORITY = "SOFTWARE\\ej-technologies\\exe4j\\priority";
    private static List<Info> installedServices = new ArrayList<Info>();

    public static List<Info> getInstalledServices() {
        return installedServices;
    }

    private String getUsedPassword() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            return this.getPassword();
        }
        return "";
    }

    private String getAccountNameOrSidForPrivileges() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            return this.getAccountNameOrSid();
        }
        return null;
    }

    private String getUsedAccountName() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            String accountName = WinUser.getAccountName(this.getAccountNameOrSid());
            if (accountName != null) {
                return accountName;
            }
            return this.getAccountNameOrSid();
        }
        return this.serviceAccount.getAccountName();
    }

    public String getWindowsDisplayName() {
        return InstallServiceAction.replaceVariables(this.windowsDisplayName);
    }

    public void setWindowsDisplayName(String windowsDisplayName) {
        this.windowsDisplayName = windowsDisplayName;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        File usedExecutable;
        String usedName;
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.setDetailMessage("");
        String additionalPlistContent = "";
        if (this.getLauncherId() == null) {
            usedName = this.getServiceName();
            usedExecutable = context.getDestinationFile(this.getExecutable());
        } else {
            LauncherSetup launcherSetup = context.getLauncherById(this.getLauncherId());
            if (launcherSetup == null) {
                Logger.getInstance().log(this, "The launcher with ID " + this.getLauncherId() + " cannot be found", false);
                return false;
            }
            usedExecutable = context.getDestinationFile(launcherSetup.getRelativeFileName());
            usedName = launcherSetup.getName();
            additionalPlistContent = InstallServiceAction.replaceVariables(((ContextImpl.LauncherSetupImpl)launcherSetup).getLauncherConfig().getPlistContent());
        }
        if (!usedExecutable.exists()) {
            Logger.getInstance().log(this, "The executable " + usedExecutable + " does not exist", false);
            return false;
        }
        String usedIdentifier = null;
        String binaryPath = usedExecutable.getAbsolutePath();
        try {
            if (InstallerUtil.isWindows()) {
                if (binaryPath.indexOf(32) > -1) {
                    binaryPath = "\"" + binaryPath + "\"";
                }
                if (this.getWindowsArguments() != null && this.getWindowsArguments().trim().length() > 0) {
                    binaryPath = binaryPath + " " + this.getWindowsArguments().trim();
                }
                String usedDisplayName = usedName;
                if (this.getWindowsDisplayName() != null && this.getWindowsDisplayName().trim().length() > 0) {
                    usedDisplayName = this.getWindowsDisplayName().trim();
                }
                int restartMillis = InstallServiceAction.getRestartMillis(context, usedName);
                int maxRestarts = InstallServiceAction.getMaxRestarts(context, usedName);
                int resetSeconds = InstallServiceAction.getResetSeconds(context, usedName);
                Serializable ret = context.runElevated(new InstallWindowsRemoteCallable(usedName, usedDisplayName, binaryPath, this.interactive, this.delayedAutoStart, this.autoStart, this.keepCurrentAccount, this.getWindowsDependencies(), this.getUsedAccountName(), this.getUsedPassword(), this.getAccountNameOrSidForPrivileges(), this.getDescription(), this.getWindowsPriority().getValue(), this.restartOnFailure, restartMillis, maxRestarts, resetSeconds), true);
                if (ret instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)ret;
                }
            } else if (InstallerUtil.isMacOS()) {
                Serializable ret;
                usedIdentifier = this.getMacosIdentifier();
                if (usedIdentifier == null || usedIdentifier.trim().length() == 0) {
                    usedIdentifier = "com.install4j." + context.getApplicationId() + "." + usedExecutable.getName();
                    Logger.getInstance().info(this, "Using fallback identifier: " + usedIdentifier);
                }
                if ((ret = context.runElevated(new InstallMacosRemoteCallable(usedExecutable, usedName, usedIdentifier, this.autoStart, additionalPlistContent), false)) instanceof IOException) {
                    throw (IOException)ret;
                }
            } else {
                this.installUnix(usedExecutable);
            }
        }
        catch (Win32Services.ServiceException e) {
            if (e.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (e.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (e.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service does not exist.");
            } else if (e.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong or user does not have log on as service privilege.");
            } else {
                Logger.getInstance().log(e);
            }
            progressInterface.showFailure(Messages.format(Messages.getMessages().getString("ErrorInstallService"), usedName) + (e.getMessage() != null ? "\n\n" + e.getMessage() : ""));
            return false;
        }
        catch (Exception e) {
            progressInterface.showFailure(Messages.format(Messages.getMessages().getString("ErrorInstallService"), usedName) + (e.getMessage() != null ? "\n\n" + e.getMessage() : ""));
            Logger.getInstance().log(e);
            return false;
        }
        Properties persistentProperties = this.getPersistentProperties();
        persistentProperties.setProperty(PROP_SERVICE_PATH, binaryPath);
        persistentProperties.setProperty(PROP_SERVICE_NAME, usedName);
        persistentProperties.setProperty(PROP_STARTUP_TYPE, this.autoStart ? "auto" : "manual");
        if (usedIdentifier != null) {
            persistentProperties.setProperty(PROP_IDENTIFIER, usedIdentifier);
        }
        installedServices.add(new Info(usedExecutable.getAbsolutePath(), usedName, usedIdentifier));
        return true;
    }

    @Override
    public void rollback(InstallerContext context) {
        this.doUninstallation(context);
    }

    @Override
    public boolean uninstall(UninstallerContext context) {
        if (Boolean.getBoolean("install4j.dontUninstallServices")) {
            Logger.getInstance().info(this, "Keep services");
            throw new AutoUninstallNotPerformedException();
        }
        return this.doUninstallation(context);
    }

    private boolean doUninstallation(Context context) {
        Properties persistentProperties = this.getPersistentProperties();
        String serviceName = persistentProperties.getProperty(PROP_SERVICE_NAME);
        if (serviceName == null) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows()) {
                Serializable ret = context.runElevated(new UninstallWindowsRemoteCallable(serviceName, persistentProperties.getProperty(PROP_SERVICE_PATH)), true);
                if (ret instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)ret;
                }
            } else if (InstallerUtil.isMacOS()) {
                String fileName = persistentProperties.getProperty(PROP_SERVICE_PATH);
                if (fileName == null) {
                    return true;
                }
                File serviceExecutable = new File(fileName);
                if (!serviceExecutable.exists()) {
                    return true;
                }
                String startupType = persistentProperties.getProperty(PROP_STARTUP_TYPE);
                String identifier = persistentProperties.getProperty(PROP_IDENTIFIER);
                context.runElevated(new UninstallMacosRemoteCallable(serviceExecutable, serviceName, identifier, startupType), true);
            } else {
                String fileName = persistentProperties.getProperty(PROP_SERVICE_PATH);
                if (fileName == null) {
                    return true;
                }
                File serviceExecutable = new File(fileName);
                File initdLink = new File("/etc/init.d", serviceExecutable.getName());
                if (!serviceExecutable.exists() || !initdLink.exists()) {
                    return true;
                }
                UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(initdLink);
                if (fileInformation != null && fileInformation.isLink() && Objects.equals(fileInformation.getLinkTarget(), serviceExecutable.getAbsolutePath()) && initdLink.delete()) {
                    this.reloadSystemCtl();
                }
            }
            return true;
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.showFailure(Messages.format(Messages.getMessages().getString("ErrorUninstallService"), serviceName));
            return true;
        }
    }

    public void installUnix(File serviceExecutable) throws IOException {
        File linkFile = new File("/etc/init.d", serviceExecutable.getName());
        if (UnixFileSystem.createLink(serviceExecutable.getAbsolutePath(), linkFile) && this.reloadSystemCtl() && this.isAutoStart()) {
            Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(new File(SYSTEMCTL_PATH)).arguments(SYSTEMCTL_NO_ASK_PASSWORD, "enable", serviceExecutable.getName()).wait(true));
            Logger.getInstance().info(this, "systemctl enable return: " + returnValue);
        }
    }

    private boolean reloadSystemCtl() {
        File systemctlFile = new File(SYSTEMCTL_PATH);
        if (systemctlFile.isFile()) {
            Integer returnValue = LaunchHelper.launchApplication(new LaunchDescriptor(systemctlFile).arguments(SYSTEMCTL_NO_ASK_PASSWORD, "daemon-reload").wait(true));
            Logger.getInstance().info(this, "systemctl return: " + returnValue);
            return returnValue != null && returnValue == 0;
        }
        return false;
    }

    private static String formatRequires(String requires) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(requires, ",");
        while (tok.hasMoreTokens()) {
            buffer.append("\"");
            buffer.append(tok.nextToken().trim());
            buffer.append("\"");
            if (!tok.hasMoreTokens()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String getServiceName() {
        return InstallServiceAction.replaceVariables(this.serviceName);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public File getExecutable() {
        return InstallServiceAction.replaceVariables(this.executable);
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public String getWindowsArguments() {
        return InstallServiceAction.replaceVariables(this.windowsArguments);
    }

    public void setWindowsArguments(String windowsArguments) {
        this.windowsArguments = windowsArguments;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String launcherId) {
        this.launcherId = launcherId;
    }

    public String getDescription() {
        return InstallServiceAction.replaceVariables(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWindowsDependencies() {
        return InstallServiceAction.replaceVariables(this.windowsDependencies);
    }

    public void setWindowsDependencies(String windowsDependencies) {
        this.windowsDependencies = windowsDependencies;
    }

    public String getMacosIdentifier() {
        return InstallServiceAction.replaceVariables(this.macosIdentifier);
    }

    public void setMacosIdentifier(String macosIdentifier) {
        this.macosIdentifier = macosIdentifier;
    }

    public boolean isRestartOnFailure() {
        return this.restartOnFailure;
    }

    public void setRestartOnFailure(boolean restartOnFailure) {
        this.restartOnFailure = restartOnFailure;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isDelayedAutoStart() {
        return this.delayedAutoStart;
    }

    public void setDelayedAutoStart(boolean delayedAutoStart) {
        this.delayedAutoStart = delayedAutoStart;
    }

    public String getAccountNameOrSid() {
        return InstallServiceAction.replaceVariables(this.accountNameOrSid);
    }

    public void setAccountNameOrSid(String accountNameOrSid) {
        this.accountNameOrSid = accountNameOrSid;
    }

    public String getPassword() {
        return InstallServiceAction.replaceVariables(this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean isKeepCurrentAccount() {
        return this.keepCurrentAccount;
    }

    public void setKeepCurrentAccount(boolean keepCurrentAccount) {
        this.keepCurrentAccount = keepCurrentAccount;
    }

    public WindowsPriority getWindowsPriority() {
        return this.windowsPriority;
    }

    public void setWindowsPriority(WindowsPriority windowsPriority) {
        this.windowsPriority = windowsPriority;
    }

    @Override
    public Object getLogValueForProperty(String propertyName, Object propertyValue) {
        if (Objects.equals(propertyName, "password") && !Boolean.getBoolean("install4j.logServicePassword")) {
            return "[logging of password is disabled]";
        }
        return propertyValue;
    }

    private static int getRestartMillis(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceRestartMillis." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_RESTART_MILLIS, 1000));
    }

    private static int getMaxRestarts(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceMaxRestarts." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_MAX_RESTARTS, 0));
    }

    private static int getResetSeconds(Context context, String serviceName) {
        return CompilerVariableHelper.getCompilerExtensionVariable(context, "serviceResetSeconds." + serviceName, CompilerVariableHelper.getCompilerExtensionVariable(context, NAME_RESET_SECONDS, 0));
    }

    public static class Info {
        private String executable;
        private String serviceName;
        private String macosIdentifier;

        public Info(String executable, String serviceName, String macosIdentifier) {
            this.executable = executable;
            this.serviceName = serviceName;
            this.macosIdentifier = macosIdentifier;
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String executable) {
            this.executable = executable;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getMacosIdentifier() {
            return this.macosIdentifier;
        }
    }

    private static class InstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        File execFile;
        String name;
        String identifier;
        private boolean autoStart;
        private final String additionalPlistContent;

        private InstallMacosRemoteCallable(File execFile, String name, String identifier, boolean autoStart, String additionalPlistContent) {
            this.execFile = execFile;
            this.name = name;
            this.identifier = identifier;
            this.autoStart = autoStart;
            this.additionalPlistContent = additionalPlistContent;
        }

        @Override
        public Serializable execute() {
            if (!this.execFile.exists()) {
                return null;
            }
            try {
                if (VersionCheck.checkCompatible("10.4", System.getProperty("os.version"))) {
                    File startupItemDir = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.name);
                    FileUtil.deleteDirectory(startupItemDir);
                    this.createLaunchDaemon();
                } else if (this.autoStart) {
                    this.createStartupItem();
                }
            }
            catch (IOException e) {
                return e;
            }
            return null;
        }

        private void createLaunchDaemon() throws IOException {
            File plistFile = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plistFile), StandardCharsets.UTF_8));
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>Label</key>\n    <string>" + this.identifier + "</string>\n    <key>ProgramArguments</key>\n    <array>\n        <string>" + this.execFile.getCanonicalPath() + "</string>\n        <string>start-launchd</string>\n    </array>\n    <key>KeepAlive</key>\n    <false/>\n    <key>RunAtLoad</key>\n    <" + this.autoStart + "/>\n" + this.additionalPlistContent + "</dict>\n</plist>");
            pw.close();
            UnixFileSystem.setMode("644", plistFile);
        }

        public void createStartupItem() throws IOException {
            File destinationDir = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.name);
            destinationDir.mkdirs();
            FileUtil.emptyDirectory(destinationDir);
            File startupExecFile = new File(destinationDir, this.name);
            PrintWriter pw = new PrintWriter(new FileWriter(startupExecFile));
            pw.println("#! /bin/sh");
            pw.println("\"" + this.execFile.getAbsolutePath() + "\" $@");
            pw.close();
            UnixFileSystem.setMode(493, startupExecFile);
            File pListFile = new File(destinationDir, InstallServiceAction.STARTUP_PARAMETERS_PLIST_NAME);
            pw = new PrintWriter(new FileWriter(pListFile));
            pw.println("{");
            pw.println("  Description     = \"" + this.name + "\";");
            pw.println("  Provides        = (\"" + this.name + "\");");
            pw.println("  Requires        = (" + InstallServiceAction.formatRequires(this.identifier) + ");");
            pw.println("  OrderPreference = \"Late\";");
            pw.println("}");
            pw.close();
        }
    }

    private static class UninstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        private File serviceExecutable;
        String serviceName;
        private String identifier;
        private String startupType;

        private UninstallMacosRemoteCallable(File serviceExecutable, String serviceName, String identifier, String startupType) {
            this.serviceExecutable = serviceExecutable;
            this.serviceName = serviceName;
            this.identifier = identifier;
            this.startupType = startupType;
        }

        @Override
        public Serializable execute() {
            File plistFile;
            if (this.serviceName != null && this.serviceName.trim().length() > 0 && Objects.equals("auto", this.startupType)) {
                File dir = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.serviceName);
                FileUtil.deleteDirectory(dir);
            }
            if (this.identifier != null && (plistFile = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist")).exists()) {
                LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
                Integer returnValue = LaunchHelper.launchApplication(launchDescriptor.arguments("unload", plistFile.getAbsolutePath()));
                Logger.getInstance().info(this, "Unload: " + (returnValue != null && returnValue == 0));
                if (!plistFile.delete()) {
                    plistFile.deleteOnExit();
                }
                return null;
            }
            try {
                Execution.executeAndWait(new String[]{"/bin/sh", this.serviceExecutable.getAbsolutePath(), "stop"}, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class InstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String usedName;
        String displayName;
        String binaryPath;
        private boolean interactive;
        private final boolean delayedAutoStart;
        private boolean autoStart;
        private boolean keepCurrentAccount;
        private String dependencies;
        private String accountName;
        private String password;
        private String accountNameOrSidForPrivileges;
        private String description;
        private int priority;
        private boolean restartOnFailure;
        private final int restartMillis;
        private final int maxRestarts;
        private final int resetSeconds;

        private InstallWindowsRemoteCallable(String usedName, String displayName, String binaryPath, boolean interactive, boolean delayedAutoStart, boolean autoStart, boolean keepCurrentAccount, String dependencies, String accountName, String password, String accountNameOrSidForPrivileges, String description, int priority, boolean restartOnFailure, int restartMillis, int maxRestarts, int resetSeconds) {
            this.usedName = usedName;
            this.displayName = displayName;
            this.binaryPath = binaryPath;
            this.interactive = interactive;
            this.delayedAutoStart = delayedAutoStart;
            this.autoStart = autoStart;
            this.keepCurrentAccount = keepCurrentAccount;
            this.dependencies = dependencies;
            this.accountName = accountName;
            this.password = password;
            this.accountNameOrSidForPrivileges = accountNameOrSidForPrivileges;
            this.description = description;
            this.priority = priority;
            this.restartOnFailure = restartOnFailure;
            this.restartMillis = restartMillis;
            this.maxRestarts = maxRestarts;
            this.resetSeconds = resetSeconds;
        }

        @Override
        public Serializable execute() {
            boolean existing = false;
            try {
                try {
                    Win32Services.installService(this.usedName, this.displayName, this.binaryPath);
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1073) {
                        existing = true;
                    }
                    throw e;
                }
                if (this.keepCurrentAccount && existing) {
                    this.accountName = null;
                    this.password = null;
                    this.accountNameOrSidForPrivileges = null;
                }
                WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY);
                WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY, this.usedName, this.priority);
                Win32Services.changeServiceConfig(this.usedName, this.displayName, this.binaryPath, this.interactive, this.autoStart ? 2 : 3, this.dependencies, this.accountName, this.password, this.description);
                Win32Services.setRestartServiceConfig(this.usedName, this.restartOnFailure, this.restartMillis, this.maxRestarts, this.resetSeconds);
                if (InstallerUtil.isAtLeastWindowsVista()) {
                    Win32Services.setDelayedAutoStart(this.usedName, this.delayedAutoStart);
                }
                if (this.accountNameOrSidForPrivileges != null) {
                    Win32UserInfo.setLsaAccountRight(this.accountNameOrSidForPrivileges, "SeServiceLogonRight", true);
                }
            }
            catch (Win32Services.ServiceException e) {
                return e;
            }
            return null;
        }
    }

    private static class UninstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String serviceName;
        private String binaryPath;

        private UninstallWindowsRemoteCallable(String serviceName, String binaryPath) {
            this.serviceName = serviceName;
            this.binaryPath = binaryPath;
        }

        @Override
        public Serializable execute() {
            block3: {
                try {
                    String registeredBinary = Win32Services.getServiceBinary(this.serviceName);
                    if (this.binaryPath == null || this.binaryPath.equals(registeredBinary)) {
                        Win32Services.uninstallService(this.serviceName);
                    }
                }
                catch (Win32Services.ServiceException e) {
                    if (e.getErrorCode() == 1060) break block3;
                    return e;
                }
            }
            return null;
        }
    }
}

