/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.properties;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.properties.AbstractPropertiesFileAction;
import com.install4j.runtime.beans.actions.properties.PropertiesFileParameters;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ReadPropertiesFileAction
extends AbstractPropertiesFileAction {
    private String variableName;
    private boolean merge;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        File usedFile = this.resolveRelativeFile(this.getFile(), context);
        if (!usedFile.exists()) {
            Logger.getInstance().error(this, "The file " + usedFile.getAbsolutePath() + " does not exist.");
            return false;
        }
        PropertiesFileParameters parameters = new PropertiesFileParameters(this.getEncoding(), this.getCharsetName());
        TextProperties properties = this.getTextProperties(context);
        try {
            properties.read(usedFile, parameters);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        context.setVariable(this.getVariableName(), properties);
        return true;
    }

    private TextProperties getTextProperties(Context context) {
        TextProperties textProperties = new TextProperties();
        Object existingValue = context.getVariable(this.getVariableName());
        if (this.isMerge()) {
            if (existingValue instanceof TextProperties) {
                return (TextProperties)existingValue;
            }
            if (existingValue instanceof Map) {
                Map map = (Map)existingValue;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    textProperties.put(key.toString(), value.toString());
                }
            }
        }
        return textProperties;
    }
}

