/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.jdbc;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.jdbc.AbstractJdbcAction;
import com.install4j.runtime.beans.actions.jdbc.ScriptSource;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.LineIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ExecuteSqlScriptAction
extends AbstractJdbcAction {
    private ScriptSource scriptSource = ScriptSource.DIRECT;
    private String script = "";
    private ExternalFile scriptFile;
    private String encoding = "";
    private String delimiter = ";";
    private boolean commitEachStatement = false;
    private boolean ignoreErrors = false;

    public ScriptSource getScriptSource() {
        return this.scriptSource;
    }

    public void setScriptSource(ScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public ExternalFile getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(ExternalFile scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getEncoding() {
        return ExecuteSqlScriptAction.replaceVariables(this.encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ExecuteSqlScriptAction.replaceVariables(this.delimiter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isCommitEachStatement() {
        return this.commitEachStatement;
    }

    public void setCommitEachStatement(boolean commitEachStatement) {
        this.commitEachStatement = commitEachStatement;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @Override
    protected boolean executeJdbcCall(final Context context) throws UserCanceledException {
        return this.withStatement(new AbstractJdbcAction.StatementConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Statement statement) throws SQLException {
                Iterator lineIterator = ExecuteSqlScriptAction.this.createLineIterator(context);
                if (lineIterator == null) {
                    return false;
                }
                try {
                    Connection connection = statement.getConnection();
                    if (!ExecuteSqlScriptAction.this.isCommitEachStatement()) {
                        connection.setAutoCommit(false);
                    }
                    StringBuilder buffer = new StringBuilder();
                    while (lineIterator.hasNext()) {
                        String replacedLine = AbstractBean.replaceVariables(((String)lineIterator.next()).trim());
                        for (String line : replacedLine.split("\n")) {
                            boolean execute;
                            buffer.append(line);
                            String delimiter = ExecuteSqlScriptAction.this.getDelimiter();
                            boolean bl = execute = line.contains(delimiter) || delimiter.equals("\\n");
                            if (execute) {
                                if (!Objects.equals(delimiter, "\n") && line.endsWith(delimiter)) {
                                    buffer.setLength(buffer.length() - delimiter.length());
                                }
                                if (buffer.length() > 0) {
                                    String[] singleStatements;
                                    for (String singleStatement : singleStatements = buffer.toString().split(delimiter)) {
                                        if (ExecuteSqlScriptAction.this.executeLine(statement, connection, singleStatement)) continue;
                                        boolean bl2 = false;
                                        return bl2;
                                    }
                                }
                                buffer.setLength(0);
                                continue;
                            }
                            buffer.append('\n');
                        }
                    }
                    if (buffer.length() > 0 && !ExecuteSqlScriptAction.this.executeLine(statement, connection, buffer.toString())) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!ExecuteSqlScriptAction.this.isCommitEachStatement()) {
                        connection.commit();
                        connection.setAutoCommit(true);
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (lineIterator instanceof Closeable) {
                        try {
                            ((Closeable)((Object)lineIterator)).close();
                        }
                        catch (IOException e) {
                            Logger.getInstance().log(e);
                        }
                    }
                }
            }
        });
    }

    private boolean executeLine(Statement statement, Connection connection, String line) throws SQLException {
        block2: {
            try {
                statement.execute(line);
            }
            catch (SQLException e) {
                this.logError("Error executing script line \"" + line + "\", error message: \"" + e.getMessage() + "\"");
                if (this.ignoreErrors) break block2;
                connection.rollback();
                return false;
            }
        }
        return true;
    }

    private Iterator<String> createLineIterator(Context context) {
        switch (this.getScriptSource()) {
            case DIRECT: {
                return Arrays.asList(this.getScript().split("\n")).iterator();
            }
            case FILE: {
                File file = context.getExternalFile(this.getScriptFile(), false);
                try {
                    return new LineIterator(FileUtil.createTextFileReader(file, this.getEncoding()));
                }
                catch (FileNotFoundException e) {
                    Logger.getInstance().log(this, "The script file " + file + " could not be found", false);
                    return null;
                }
                catch (IOException e) {
                    Logger.getInstance().log(this, "Error reading script file " + file + "", false);
                    Logger.getInstance().log(e);
                    return null;
                }
            }
        }
        throw new RuntimeException(this.getScriptSource().name());
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }
}

