/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.FileTarget;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public class SetModeAction
extends AbstractRecursiveFileAction {
    private String mode;
    private boolean recursive;
    private FileTarget fileTarget = FileTarget.EVERYTHING;

    public String getMode() {
        return SetModeAction.replaceVariables(this.mode);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public FileTarget getFileTarget() {
        return this.fileTarget;
    }

    public void setFileTarget(FileTarget fileTarget) {
        this.fileTarget = fileTarget;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        String newMode = this.getMode();
        if (newMode == null || newMode.trim().length() == 0) {
            Logger.getInstance().log(this, "Mode is not set", false);
            return false;
        }
        return super.execute(context);
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        if (this.fileTarget == null || this.fileTarget.isIncluded(file)) {
            UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
            if (fileInformation != null && fileInformation.getMode() > -1) {
                this.addRollbackAction(new PerformedAction(fileInformation.getMode(), file));
            }
            Util.logInfo(this, "Setting mode for " + file.getAbsolutePath());
            return UnixFileSystem.setMode(this.getMode(), file);
        }
        return true;
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private int oldMode;
        private File file;

        public PerformedAction(int oldMode, File file) {
            this.oldMode = oldMode;
            this.file = file;
        }

        @Override
        public boolean install(InstallerContext context) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rollback(InstallerContext context) {
            UnixFileSystem.setMode(this.oldMode, this.file);
        }
    }
}

