/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.NullOutputStream;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.ArchiveFileOperationRoot;
import com.install4j.runtime.beans.actions.files.ZipMethod;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateZipFileAction
extends AbstractRecursiveFileAction {
    private File zipFile;
    private ArchiveFileOperationRoot zipRoot = ArchiveFileOperationRoot.INSTALLATION_DIRECTORY;
    private boolean addTopLevelDirectoriesToRelativePath;
    private transient ZipOutputStream zipOutputStream;
    protected transient Map<File, Integer> fileToMethod;
    private ZipMethod method = ZipMethod.DEFLATED;

    public CreateZipFileAction(Map<File, Integer> fileToMethod) {
        this.fileToMethod = fileToMethod;
    }

    public CreateZipFileAction() {
    }

    public File getZipFile() {
        return CreateZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public ArchiveFileOperationRoot getZipRoot() {
        return this.zipRoot;
    }

    public void setZipRoot(ArchiveFileOperationRoot zipRoot) {
        this.zipRoot = zipRoot;
    }

    public ZipMethod getMethod() {
        return this.method;
    }

    public void setMethod(ZipMethod method) {
        this.method = method;
    }

    @Override
    public boolean isAddTopLevelDirectoriesToRelativePath() {
        return this.addTopLevelDirectoriesToRelativePath;
    }

    public void setAddTopLevelDirectoriesToRelativePath(boolean addTopLevelDirectoriesToRelativePath) {
        this.addTopLevelDirectoriesToRelativePath = addTopLevelDirectoriesToRelativePath;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        try {
            File zipFile = this.resolveRelativeFile(this.getZipFile(), this.getZipRoot(), context);
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
        boolean success = super.execute(context);
        if (success) {
            try {
                this.zipOutputStream.close();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
                return false;
            }
        }
        return success;
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        String entryName = relativeSourceFile.getPath().replace('\\', '/');
        if (entryName.startsWith("./")) {
            entryName = entryName.substring(2);
        }
        if (file.isDirectory()) {
            entryName = entryName + "/";
        }
        if (!Objects.equals(entryName, "./")) {
            Logger.getInstance().info(null, "adding entry " + entryName);
            ZipEntry zipEntry = new ZipEntry(entryName);
            zipEntry.setTime(file.lastModified());
            if (file.isFile()) {
                Integer previousMethod;
                int usedMethod = this.method.getIntValue();
                if (this.fileToMethod != null && (previousMethod = this.fileToMethod.get(file)) != null) {
                    usedMethod = previousMethod;
                }
                if (usedMethod == 0) {
                    try (CheckedInputStream in = new CheckedInputStream(new FileInputStream(file), new CRC32());){
                        FileUtil.pumpStream(in, new NullOutputStream());
                        zipEntry.setCrc(in.getChecksum().getValue());
                    }
                    long length = file.length();
                    zipEntry.setSize(length);
                    zipEntry.setCompressedSize(length);
                }
                zipEntry.setMethod(usedMethod);
            }
            this.zipOutputStream.putNextEntry(zipEntry);
            if (file.isFile()) {
                try (FileInputStream in = new FileInputStream(file);){
                    FileUtil.pumpStream(in, this.zipOutputStream, progressAdapter);
                }
            }
            this.zipOutputStream.closeEntry();
        }
        return true;
    }
}

