/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractExtractArchiveAction
extends SystemInstallOrUninstallAction {
    private File archiveFile;
    private File destinationDirectory;
    private ScriptProperty fileFilter;
    private boolean showProgress = true;
    private boolean showFileNames = true;

    public File getArchiveFile() {
        return AbstractExtractArchiveAction.replaceVariables(this.archiveFile);
    }

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public File getDestinationDirectory() {
        return AbstractExtractArchiveAction.replaceVariables(this.destinationDirectory);
    }

    public void setDestinationDirectory(File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public ScriptProperty getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(ScriptProperty fileFilter) {
        this.fileFilter = fileFilter;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileNames() {
        return this.showFileNames;
    }

    public void setShowFileNames(boolean showFileNames) {
        this.showFileNames = showFileNames;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!this.isAvailable()) {
            return true;
        }
        File usedFile = context.getDestinationFile(this.getArchiveFile());
        if (usedFile == null || !usedFile.isFile()) {
            Logger.getInstance().error(this, "archive file " + this.getArchiveFile() + " (" + usedFile + ", " + this.archiveFile + ") does not exist.");
            return false;
        }
        File usedDestination = context.getDestinationFile(this.getDestinationDirectory());
        if (usedDestination == null) {
            Logger.getInstance().error(this, "could not resolve destination " + this.getDestinationDirectory() + ", " + this.destinationDirectory);
            return false;
        }
        try {
            return this.extract(context, usedFile, usedDestination);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    protected abstract boolean extract(Context var1, File var2, File var3) throws IOException;

    protected final void initProgress(ProgressInterface progressInterface, int value) {
        if (this.isShowProgress()) {
            progressInterface.setPercentCompleted(value);
            if (this.isShowFileNames()) {
                progressInterface.setDetailMessage("");
            }
        }
    }

    protected boolean isAvailable() {
        return true;
    }
}

