/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;

public class CreateStartMenuEntryAction
extends SystemInstallAction {
    private boolean allUsers = true;
    private String entryName = "";
    private String arguments = "";
    private String categories = "Application";
    private File file;
    private ExternalFile icon;
    private ExternalFile unixIconFile;
    private String programGroupName = "${installer:sys.programGroupName}";
    private File startIn;
    private boolean runAsAdministrator = false;

    public File getStartIn() {
        return CreateStartMenuEntryAction.replaceVariables(this.startIn);
    }

    public void setStartIn(File startIn) {
        this.startIn = startIn;
    }

    public boolean isRunAsAdministrator() {
        return this.runAsAdministrator;
    }

    public void setRunAsAdministrator(boolean runAsAdministrator) {
        this.runAsAdministrator = runAsAdministrator;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            File destinationFile = context.getDestinationFile(this.getFile());
            if (InstallerUtil.isWindows()) {
                File startIn;
                String entryName = this.getEntryName();
                File menuFile = new File(entryName);
                boolean allUsers = this.isAllUsers();
                if (!menuFile.isAbsolute()) {
                    if (allUsers && !InstallerUtil.checkWritable(FolderInfo.getSpecialFolder(3, true))) {
                        allUsers = false;
                    }
                    File folder = FolderInfo.getSpecialFolder(3, allUsers);
                    if (this.getProgramGroupName().trim().length() > 0) {
                        folder = new File(folder, this.getProgramGroupName().trim());
                    }
                    menuFile = new File(folder, entryName);
                }
                if ((startIn = context.getDestinationFile(this.getStartIn())) != null && !startIn.isDirectory()) {
                    startIn = null;
                }
                MenuHelper.installWindowsMenu(allUsers ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, menuFile, destinationFile, context.getExternalFile(this.getIcon(), true), this.getArguments(), this.isRunAsAdministrator(), null, startIn);
            } else if (!InstallerUtil.isMacOS()) {
                LauncherSetup launcherSetup = MenuHelper.getLauncherWithUnixPath(context, destinationFile);
                MenuHelper.installUnixMenu(context.getInstallationDirectory(), destinationFile, this.getEntryName(), this.getCategories(), this.getArguments(), context.getExternalFile(this.getUnixIconFile(), true), null, MenuHelper.getUnixWindowClass(context, launcherSetup), MenuHelper.getUnixMimeType(context, launcherSetup));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getProgramGroupName() {
        try {
            return CreateStartMenuEntryAction.replaceVariables(this.programGroupName);
        }
        catch (UndefinedVariableException e) {
            return "";
        }
    }

    public void setProgramGroupName(String programGroupName) {
        this.programGroupName = programGroupName;
    }

    public String getArguments() {
        return CreateStartMenuEntryAction.replaceVariables(this.arguments);
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getCategories() {
        return CreateStartMenuEntryAction.replaceVariables(this.categories);
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getEntryName() {
        return CreateStartMenuEntryAction.replaceVariables(this.entryName, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public File getFile() {
        return CreateStartMenuEntryAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ExternalFile getIcon() {
        return this.icon;
    }

    public void setIcon(ExternalFile icon) {
        this.icon = icon;
    }

    public ExternalFile getUnixIconFile() {
        return this.unixIconFile;
    }

    public void setUnixIconFile(ExternalFile unixIconFile) {
        this.unixIconFile = unixIconFile;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean allUsers) {
        this.allUsers = allUsers;
    }
}

