/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.utilities;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class StringConverter {
    public static final int[] s_fractionalMultiplier = new int[]{0, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] s_daysInMonth = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static Date parseDate(String string, Calendar calendar) {
        if (null == string) {
            return null;
        }
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(45);
        if (-1 == n2 || n2 > 9) {
            return null;
        }
        int n3 = StringConverter.parseInt(string, 0, n2);
        int n4 = string.indexOf(45, n2 + 1);
        if (-1 == n4 || n4 - n2 > 3) {
            return null;
        }
        int n5 = StringConverter.parseInt(string, n2 + 1, n4);
        if (n - n4 > 3) {
            return null;
        }
        int n6 = StringConverter.parseInt(string, n4 + 1, n);
        if (!StringConverter.checkDate(n3, n5, n6)) {
            return null;
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        calendar.set(n3, n5 - 1, n6, 0, 0, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static int parseInt(String string, int n, int n2) {
        assert (null != string && n <= n2 && n >= 0 && n2 >= 0 && n < string.length() && n2 <= string.length());
        if (n >= n2 || n2 - n > 9) {
            return -1;
        }
        int n3 = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c < '0' || c > '9') {
                return -1;
            }
            n3 *= 10;
            n3 += c - 48;
            ++n;
        }
        return n3;
    }

    public static Time parseTime(String string, Calendar calendar) {
        if (null == string) {
            throw new IllegalArgumentException();
        }
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(58);
        if (-1 == n2 || n2 > 3) {
            throw new IllegalArgumentException();
        }
        int n3 = StringConverter.parseInt(string, 0, n2);
        int n4 = string.indexOf(58, n2 + 1);
        if (-1 == n4 || n4 - n2 > 3) {
            throw new IllegalArgumentException();
        }
        int n5 = StringConverter.parseInt(string, n2 + 1, n4);
        if (n - n4 > 3) {
            throw new IllegalArgumentException();
        }
        int n6 = StringConverter.parseInt(string, n4 + 1, n);
        if (!StringConverter.checkTime(n3, n5, n6)) {
            throw new IllegalArgumentException();
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        calendar.set(1970, 0, 1, n3, n5, n6);
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    public static Timestamp parseTimestamp(String string, Calendar calendar) {
        int n;
        int n2;
        int n3;
        if (null == string) {
            throw new IllegalArgumentException();
        }
        int n4 = (string = string.trim()).indexOf(45);
        if (-1 == n4 || n4 > 9) {
            throw new IllegalArgumentException();
        }
        int n5 = StringConverter.parseInt(string, 0, n4);
        int n6 = string.indexOf(45, n4 + 1);
        if (-1 == n6 || n6 - n4 > 3) {
            throw new IllegalArgumentException();
        }
        int n7 = StringConverter.parseInt(string, n4 + 1, n6);
        int n8 = string.indexOf(32, n6 + 1);
        if (-1 == n8 || n8 - n6 > 3) {
            throw new IllegalArgumentException();
        }
        int n9 = StringConverter.parseInt(string, n6 + 1, n8);
        int n10 = string.indexOf(58, n8 + 1);
        if (-1 == n10 || n10 - n8 > 3) {
            throw new IllegalArgumentException();
        }
        int n11 = StringConverter.parseInt(string, n8 + 1, n10);
        int n12 = string.indexOf(58, n10 + 1);
        if (-1 == n12 || n12 - n10 > 3) {
            throw new IllegalArgumentException();
        }
        int n13 = StringConverter.parseInt(string, n10 + 1, n12);
        int n14 = string.indexOf(46, n12 + 1);
        boolean bl = -1 != n14;
        int n15 = string.length();
        int n16 = n3 = bl ? n14 : n15;
        if (n3 - n12 > 3) {
            throw new IllegalArgumentException();
        }
        int n17 = StringConverter.parseInt(string, n12 + 1, n3);
        if (bl) {
            n2 = n15 - n14 - 1;
            if (n2 > 9) {
                throw new IllegalArgumentException();
            }
            n = StringConverter.parseInt(string, n14 + 1, n15);
        } else {
            n = 0;
            n2 = 0;
        }
        if (!StringConverter.checkDate(n5, n7, n9) || !StringConverter.checkTime(n11, n13, n17) || -1 == n) {
            throw new IllegalArgumentException();
        }
        if (null == calendar) {
            calendar = Calendar.getInstance();
        }
        calendar.set(n5, n7 - 1, n9, n11, n13, n17);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n * s_fractionalMultiplier[n2]);
        return timestamp;
    }

    private static boolean checkDate(int n, int n2, int n3) {
        if (n < 0) {
            return false;
        }
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        return n3 >= 0 && n3 <= s_daysInMonth[n2];
    }

    private static boolean checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        return n3 >= 0 && n3 <= 61;
    }
}

