/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.filter.AbstractRowFilterModel;
import de.javasoft.swing.filter.IRowFilterFactory;
import de.javasoft.swing.sort.RowFilters;
import javax.swing.RowFilter;

public class SimpleRowFilterModel<M>
extends AbstractRowFilterModel<M> {
    private IRowFilterFactory<? super M> rowFilterFactory;

    public SimpleRowFilterModel() {
        this(0);
    }

    public SimpleRowFilterModel(int columnIndex) {
        this(columnIndex, null);
    }

    public SimpleRowFilterModel(int columnIndex, IRowFilterFactory<? super M> factory) {
        super(columnIndex);
        this.setRowFilterFactory(factory);
    }

    public void setRowFilterFactory(IRowFilterFactory<? super M> factory) {
        if (factory == null) {
            factory = this.createDefaultRowFilterFactory();
        }
        this.rowFilterFactory = factory;
        this.setRowFilter(this.createRowFilter());
    }

    protected IRowFilterFactory<? super M> getRowFilterFactory() {
        return this.rowFilterFactory;
    }

    @Override
    protected RowFilter<? super M, ? super Integer> createRowFilter() {
        return this.getRowFilterFactory().createRowFilter(this.getMatchValue(), this.getColumnIndex());
    }

    protected IRowFilterFactory<M> createDefaultRowFilterFactory() {
        return new EqualsRowFilterFactory();
    }

    public static class EqualsRowFilterFactory<M>
    implements IRowFilterFactory<M> {
        @Override
        public RowFilter<? super M, ? super Integer> createRowFilter(Object matchValue, int ... columns) {
            if (this.isEmpty(matchValue)) {
                return null;
            }
            return RowFilters.equalsFilter(matchValue, columns);
        }

        protected boolean isEmpty(Object matchValue) {
            if (matchValue instanceof String) {
                String dummy = ((String)matchValue).trim();
                return dummy.length() == 0;
            }
            return matchValue == null;
        }
    }
}

