/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.parser;

import com.jidesoft.thirdparty.prefuse.data.parser.DataParseException;
import com.jidesoft.thirdparty.prefuse.data.parser.DataParser;

public class LongParser
implements DataParser {
    @Override
    public Class getType() {
        return Long.TYPE;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).longValue()) + "L";
    }

    @Override
    public boolean canParse(String string) {
        try {
            this.parseLong(string);
            return true;
        }
        catch (DataParseException dataParseException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        return new Long(this.parseLong(string));
    }

    public long parseLong(String string) throws DataParseException {
        try {
            char c2;
            if (string.length() > 0 && ((c2 = string.charAt(string.length() - 1)) == 'l' || c2 == 'L')) {
                string = string.substring(0, string.length() - 1);
            }
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

