/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.beans.ConstructorProperties;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class JideTitledBorder
extends AbstractBorder {
    private static final long \u0101 = 5409659168893849250L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private final JLabel \u0102;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 0;

    public JideTitledBorder(String string) {
        this(null, string, 4, 0, null, null);
    }

    public JideTitledBorder(Border border) {
        this(border, "", 4, 0, null, null);
    }

    public JideTitledBorder(Border border, String string) {
        this(border, string, 4, 0, null, null);
    }

    public JideTitledBorder(Border border, String string, int n2, int n3) {
        this(border, string, n2, n3, null, null);
    }

    public JideTitledBorder(Border border, String string, int n2, int n3, Font font) {
        this(border, string, n2, n3, font, null);
    }

    @ConstructorProperties(value={"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"})
    public JideTitledBorder(Border border, String string, int n2, int n3, Font font, Color color) {
        this.title = string;
        this.border = border;
        this.titleFont = font;
        this.titleColor = color;
        this.setTitleJustification(n2);
        this.setTitlePosition(n3);
        this.\u0102 = new JLabel();
        this.\u0102.setOpaque(false);
        this.\u0102.putClientProperty("html", null);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Border border = this.\u0102();
        String string = this.getTitle();
        if (string != null && !string.isEmpty()) {
            int n6 = border instanceof JideTitledBorder ? 0 : 2;
            JLabel jLabel = this.\u0102(component);
            Dimension dimension = jLabel.getPreferredSize();
            Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
            int n7 = n2 + n6;
            int n8 = n3 + n6;
            int n9 = n4 - n6 - n6;
            int n10 = n5 - n6 - n6;
            int n11 = n3;
            int n12 = dimension.height;
            int n13 = this.\u0101();
            switch (n13) {
                case 1: {
                    insets.left = 0;
                    insets.right = 0;
                    n8 += n12 - n6;
                    n10 -= n12 - n6;
                    break;
                }
                case 2: {
                    insets.top = n6 + insets.top / 2 - n12 / 2;
                    if (insets.top < n6) {
                        n8 -= insets.top;
                        n10 += insets.top;
                        break;
                    }
                    n11 += insets.top;
                    break;
                }
                case 3: {
                    n11 += insets.top + n6;
                    break;
                }
                case 4: {
                    n11 += n5 - n12 - insets.bottom - n6;
                    break;
                }
                case 5: {
                    n11 += n5 - n12;
                    insets.bottom = n6 + (insets.bottom - n12) / 2;
                    if (insets.bottom < n6) {
                        n10 += insets.bottom;
                        break;
                    }
                    n11 -= insets.bottom;
                    break;
                }
                case 6: {
                    insets.left = 0;
                    insets.right = 0;
                    n11 += n5 - n12;
                    n10 -= n12 - n6;
                }
            }
            insets.left += n6 + 0;
            insets.right += n6 + 0;
            int n14 = n2;
            int n15 = n4 - insets.left - insets.right;
            if (n15 > dimension.width) {
                n15 = dimension.width;
            }
            switch (this.\u0103(component)) {
                case 1: {
                    n14 += insets.left;
                    break;
                }
                case 3: {
                    n14 += n4 - insets.right - n15;
                    break;
                }
                case 2: {
                    n14 += (n4 - n15) / 2;
                }
            }
            if (border != null) {
                if (n13 != 2 && n13 != 5) {
                    border.paintBorder(component, graphics, n7, n8, n9, n10);
                } else {
                    Graphics graphics2 = graphics.create();
                    if (graphics2 instanceof Graphics2D) {
                        Graphics2D graphics2D = (Graphics2D)graphics2;
                        Path2D.Float float_ = new Path2D.Float();
                        float_.append(new Rectangle(n7, n8, n9, n11 - n8), false);
                        float_.append(new Rectangle(n7, n11, n14 - n7 - 2, n12), false);
                        float_.append(new Rectangle(n14 + n15 + 2, n11, n7 - n14 + n9 - n15 - 2, n12), false);
                        float_.append(new Rectangle(n7, n11 + n12, n9, n8 - n11 + n10 - n12), false);
                        graphics2D.clip(float_);
                    }
                    border.paintBorder(component, graphics2, n7, n8, n9, n10);
                    graphics2.dispose();
                }
            }
            graphics.translate(n14, n11);
            jLabel.setSize(n15, n12);
            jLabel.paint(graphics);
            graphics.translate(-n14, -n11);
        } else if (border != null) {
            border.paintBorder(component, graphics, n2, n3, n4, n5);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Object object;
        Border border = this.\u0102();
        if (border == null) {
            insets.set(0, 0, 0, 0);
        } else if (border instanceof AbstractBorder) {
            object = (AbstractBorder)border;
            insets = ((AbstractBorder)object).getBorderInsets(component, insets);
        } else {
            object = border.getBorderInsets(component);
            insets.set(((Insets)object).top, ((Insets)object).left, ((Insets)object).bottom, ((Insets)object).right);
        }
        object = this.getTitle();
        if (object != null && !((String)object).isEmpty()) {
            int n2 = border instanceof JideTitledBorder ? 0 : 2;
            JLabel jLabel = this.\u0102(component);
            Dimension dimension = jLabel.getPreferredSize();
            switch (this.\u0101()) {
                case 1: {
                    insets.top += dimension.height - n2;
                    break;
                }
                case 2: {
                    if (insets.top >= dimension.height) break;
                    insets.top = dimension.height - n2;
                    break;
                }
                case 3: {
                    insets.top += dimension.height;
                    break;
                }
                case 4: {
                    insets.bottom += dimension.height;
                    break;
                }
                case 5: {
                    if (insets.bottom >= dimension.height) break;
                    insets.bottom = dimension.height - n2;
                    break;
                }
                case 6: {
                    insets.bottom += dimension.height - n2;
                }
            }
            insets.top += n2 + 2;
            insets.left += n2 + 2;
            insets.right += n2 + 2;
            insets.bottom += n2 + 2;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        return this.border;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n2 + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n2 + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        String string = this.getTitle();
        if (string != null && !string.isEmpty()) {
            JLabel jLabel = this.\u0102(component);
            Dimension dimension2 = jLabel.getPreferredSize();
            int n2 = this.\u0101();
            if (n2 != 1 && n2 != 6) {
                dimension.width += dimension2.width;
            } else if (dimension.width < dimension2.width) {
                dimension.width += dimension2.width;
            }
        }
        return dimension;
    }

    @Override
    public int getBaseline(Component component, int n2, int n3) {
        if (component == null) {
            throw new NullPointerException("Must supply non-null component");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Width must be >= 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Height must be >= 0");
        }
        Border border = this.\u0102();
        String string = this.getTitle();
        if (string != null && !string.isEmpty()) {
            int n4 = border instanceof JideTitledBorder ? 0 : 2;
            JLabel jLabel = this.\u0102(component);
            Dimension dimension = jLabel.getPreferredSize();
            Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
            int n5 = jLabel.getBaseline(dimension.width, dimension.height);
            switch (this.\u0101()) {
                case 1: {
                    return n5;
                }
                case 2: {
                    insets.top = n4 + (insets.top - dimension.height) / 2;
                    return insets.top < n4 ? n5 : n5 + insets.top;
                }
                case 3: {
                    return n5 + insets.top + n4;
                }
                case 4: {
                    return n5 + n3 - dimension.height - insets.bottom - n4;
                }
                case 5: {
                    insets.bottom = n4 + (insets.bottom - dimension.height) / 2;
                    return insets.bottom < n4 ? n5 + n3 - dimension.height : n5 + n3 - dimension.height + insets.bottom;
                }
                case 6: {
                    return n5 + n3 - dimension.height;
                }
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(Component component) {
        super.getBaselineResizeBehavior(component);
        switch (this.\u0101()) {
            case 1: 
            case 2: 
            case 3: {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            case 4: 
            case 5: 
            case 6: {
                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    private Border \u0102() {
        Border border = this.getBorder();
        return border != null ? border : UIManager.getBorder("TitledBorder.border");
    }

    private int \u0101() {
        int n2 = this.getTitlePosition();
        if (n2 != 0) {
            return n2;
        }
        Object object = UIManager.get("TitledBorder.position");
        if (object instanceof Integer) {
            int n3 = (Integer)object;
            if (0 < n3 && n3 <= 6) {
                return n3;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.equalsIgnoreCase("ABOVE_TOP")) {
                return 1;
            }
            if (string.equalsIgnoreCase("TOP")) {
                return 2;
            }
            if (string.equalsIgnoreCase("BELOW_TOP")) {
                return 3;
            }
            if (string.equalsIgnoreCase("ABOVE_BOTTOM")) {
                return 4;
            }
            if (string.equalsIgnoreCase("BOTTOM")) {
                return 5;
            }
            if (string.equalsIgnoreCase("BELOW_BOTTOM")) {
                return 6;
            }
        }
        return 2;
    }

    private int \u0103(Component component) {
        int n2 = this.getTitleJustification();
        if (n2 == 4 || n2 == 0) {
            return component.getComponentOrientation().isLeftToRight() ? 1 : 3;
        }
        if (n2 == 5) {
            return component.getComponentOrientation().isLeftToRight() ? 3 : 1;
        }
        return n2;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        font = UIManager.getFont("TitledBorder.font");
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private Color \u0101(Component component) {
        Color color = this.getTitleColor();
        if (color != null) {
            return color;
        }
        color = UIManager.getColor("TitledBorder.titleColor");
        if (color != null) {
            return color;
        }
        return component != null ? component.getForeground() : null;
    }

    private JLabel \u0102(Component component) {
        this.\u0102.setText(this.getTitle());
        this.\u0102.setFont(this.getFont(component));
        this.\u0102.setForeground(this.\u0101(component));
        this.\u0102.setComponentOrientation(component.getComponentOrientation());
        this.\u0102.setEnabled(component.isEnabled());
        return this.\u0102;
    }
}

