/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.dsi.utilities.NullSafeStringComparator;
import com.amazon.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.amazon.sqlengine.dsiext.dataengine.Identifier;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class DSIExtCatalogsOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private IMetadataHelper m_metadataHelper;
    private List<String> m_catalogNames;
    private int m_currRow = -1;

    public DSIExtCatalogsOnlyMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_metadataHelper = iMetadataHelper;
        this.findCatalogs();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_catalogNames.get(this.m_currRow), dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currRow < this.m_catalogNames.size() - 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currRow < this.m_catalogNames.size()) {
            ++this.m_currRow;
        }
        return this.m_currRow < this.m_catalogNames.size();
    }

    private void findCatalogs() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Identifier identifier = new Identifier();
        TreeSet<String> treeSet = new TreeSet<String>(new NullSafeStringComparator());
        while (this.m_metadataHelper.getNextTable(identifier)) {
            treeSet.add(identifier.getCatalog());
        }
        this.m_catalogNames = Collections.unmodifiableList(new ArrayList<String>(treeSet));
    }
}

