/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.jdbc.common.AbstractDriver;
import com.amazon.redshift.PGInfo;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.jdbc41.PGJDBC41Driver;
import java.util.Map;
import java.util.Properties;

public class Driver
extends PGJDBC41Driver {
    @Override
    protected boolean parseSubName(String subname, Properties properties) {
        boolean parseSubNameResult = PGCoreUtils.parseSubName(subname, properties, this.m_isUsingOpenSourceSubProtocol);
        this.renameProperties(properties);
        return parseSubNameResult;
    }

    private void renameProperties(Properties properties) {
        Map<String, String> toPermuteKeys = PGJDBCPropertyKey.getKeysToBeRenammed();
        for (Map.Entry<String, String> currentPermutation : toPermuteKeys.entrySet()) {
            String permutationKey = currentPermutation.getKey();
            String permutationValue = currentPermutation.getValue();
            if (properties.containsKey(permutationValue)) {
                properties.remove(permutationValue);
            }
            if (!properties.containsKey(permutationKey)) continue;
            String value = properties.getProperty(permutationKey);
            properties.setProperty(permutationValue, value);
            properties.remove(permutationKey);
        }
    }

    @Override
    protected boolean acceptsSubProtocol(String givenSubProtocol) {
        boolean result = false;
        String[] subProtocol = this.getSubProtocols();
        if (null == subProtocol) {
            return false;
        }
        this.m_isUsingOpenSourceSubProtocol = givenSubProtocol.equals("postgresql");
        for (int i = 0; !result && i < subProtocol.length; ++i) {
            result = givenSubProtocol.equals(subProtocol[i]);
        }
        return result;
    }

    private String[] getSubProtocols() {
        return PGInfo.PG_SUBPROTOCAL_NAME;
    }

    @Override
    public String getSubProtocol() {
        return null;
    }

    static {
        try {
            AbstractDriver.initialize(new Driver(), PGJDBCDriver.class.getName());
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

