/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class PGExecutionResults
extends ExecutionResults {
    private final ILogger m_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGExecutionResults(List<PGMessagingContext> contexts, int currentExecuteIndex, ILogger logger, ExpectedResult expectedResult, int socketTimeoutMS, boolean rowCountArrayExpected, boolean prepareStage) throws ErrorException {
        this.m_log = logger;
        ArrayList<ExecutionResult> rowCountResults = null;
        try {
            for (PGMessagingContext current : contexts) {
                try {
                    boolean resultAdded = false;
                    while (!resultAdded) {
                        try {
                            IInboundMessage peeked;
                            if (current.m_totalMessageCount > current.m_currentMessageCount && (peeked = current.peekNextMessage(socketTimeoutMS)) instanceof ErrorResponse) {
                                current.getErrorResponse();
                            }
                            if (current.m_isPreparedStatement && null == current.m_readyForQueryFromPipelineForPrepare) {
                                current.getReadyForQuery();
                            }
                            if (null != current.getNoData()) {
                                if (prepareStage) {
                                    this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(0L)));
                                    resultAdded = true;
                                    continue;
                                }
                                current.getReadyForQuery();
                                if (!rowCountArrayExpected) {
                                    if (null == rowCountResults) {
                                        rowCountResults = new ArrayList();
                                    }
                                    rowCountResults.add(this.buildRowCount(expectedResult, current));
                                    resultAdded = true;
                                    continue;
                                }
                                this.addExecutionResult(this.buildRowCount(expectedResult, current));
                                resultAdded = true;
                                continue;
                            }
                            if (null != current.getRowDescription() && current.getRowDescription().getNumberOfFields() > 0) {
                                this.addExecutionResult(this.buildResultSet(expectedResult, current));
                                resultAdded = true;
                                continue;
                            }
                            if (!rowCountArrayExpected) {
                                if (null == rowCountResults) {
                                    rowCountResults = new ArrayList<ExecutionResult>();
                                }
                                rowCountResults.add(this.buildRowCount(expectedResult, current));
                                resultAdded = true;
                                continue;
                            }
                            this.addExecutionResult(this.buildRowCount(expectedResult, current));
                            resultAdded = true;
                        }
                        catch (ErrorException e) {
                            DSIErrorResult error = new DSIErrorResult(e);
                            if (expectedResult == ExpectedResult.SingleRowCount || null != current.getNoData()) {
                                this.addExecutionResult(new ExecutionResult(error, false));
                                resultAdded = true;
                                throw e;
                            } else {
                                this.addExecutionResult(new ExecutionResult(error, true));
                                resultAdded = true;
                            }
                            throw e;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorException err = current.receivedFatalExeption();
                    if (null != err) {
                        throw err;
                    }
                    if (!(ex instanceof ErrorException)) throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), (Throwable)ex);
                    throw (ErrorException)ex;
                    return;
                }
            }
        }
        finally {
            if (prepareStage) {
                return;
            }
            if (!rowCountArrayExpected && null != rowCountResults) {
                long total = 0L;
                for (ExecutionResult execResult : rowCountResults) {
                    if (!(execResult.getResult() instanceof DSISimpleRowCountResult)) continue;
                    DSISimpleRowCountResult result = (DSISimpleRowCountResult)execResult.getResult();
                    long currentUpdateCount = result.getRowCount();
                    if (PGCoreUtils.willAdditionOverflow(total, currentUpdateCount)) {
                        total = Long.MAX_VALUE;
                        continue;
                    }
                    total += currentUpdateCount;
                }
                this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(total)));
            }
        }
    }

    private ExecutionResult buildResultSet(ExpectedResult expectedResult, PGMessagingContext context) {
        if (null != expectedResult && ExpectedResult.SingleRowCount == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_ROWCOUNT_GENERATED.name(), context.m_query, ExceptionType.DEFAULT)), false);
        }
        PGResultSet resultSet = new PGResultSet(context, this.m_log);
        return new ExecutionResult(resultSet);
    }

    private ExecutionResult buildRowCount(ExpectedResult expectedResult, PGMessagingContext context) throws ErrorException {
        if (null != expectedResult && ExpectedResult.SingleResult == expectedResult) {
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_RESULTSET_GENERATED.name(), context.m_query, ExceptionType.DEFAULT)), true);
        }
        CommandComplete commandComplete = context.getCommandCompleteMessage();
        if (null == commandComplete) {
            LogUtilities.logFatal("CommandComplete is null", this.m_log);
            return new ExecutionResult(new DSIErrorResult(PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(JDBCMessageKey.NO_ROWCOUNT_GENERATED.name(), context.m_query, ExceptionType.DEFAULT)), true);
        }
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug("DSISimpleRowCountResult set to " + commandComplete.getNumRows(), this.m_log);
        }
        return new ExecutionResult(new DSISimpleRowCountResult(commandComplete.getNumRows()));
    }
}

