/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class PGBatchQueryExecutor
extends PGAbstractQueryExecutor {
    private Map<PGMessagingContext, Integer> m_parameterCountPerQuery = new HashMap<PGMessagingContext, Integer>();
    private List<String> m_queries;
    private String m_query;
    private List<PGCoreUtils.TransactionVerb> m_txCommands;

    public PGBatchQueryExecutor(String originalQuery, List<String> queries, PGClient client, ILogger log, boolean isDirectExecute, PGJDBCStatement statement, int socketTimeoutMS, boolean rowCountArrayExpected) throws ErrorException {
        LogUtilities.logFunctionEntrance(log, queries, client);
        this.m_query = originalQuery;
        this.m_queries = queries;
        this.m_log = log;
        this.m_isDirectExecute = isDirectExecute;
        this.m_client = client;
        this.m_statement = statement;
        this.m_socketTimeoutMS = socketTimeoutMS;
        this.m_contexts = new ArrayList();
        this.m_rowCountArrayExpected = rowCountArrayExpected;
        ArrayList<PGCoreUtils.TransactionVerb> txCommands = new ArrayList<PGCoreUtils.TransactionVerb>(queries.size());
        for (String query : queries) {
            PGCoreUtils.TransactionVerb txVerb = PGCoreUtils.parseTransactionVerb(query);
            if (PGCoreUtils.TransactionVerb.NONE != txVerb) {
                this.m_txCommands = txCommands;
            }
            txCommands.add(txVerb);
        }
        if (!isDirectExecute) {
            for (int queryCounter = 0; queryCounter < queries.size(); ++queryCounter) {
                PGMessagingContext messagingContext = this.m_client.prepareStatement(queries.get(queryCounter), statement.getWarningListener(), queries.size() > 1);
                messagingContext.addSocketCloseListener(this);
                messagingContext.setFinalCommandInBatch(queries.size() - 1 == queryCounter);
                this.m_contexts.add(messagingContext);
            }
        }
        this.m_statement.pushContexts(this.m_contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts contexts, IWarningListener warningListener) throws ErrorException {
        int maxRows;
        int fetchSize;
        LogUtilities.logFunctionEntrance(this.m_log, contexts, warningListener);
        this.m_prepareStage = false;
        if (null != this.m_statement.getExpectedResult() && this.m_statement.getExpectedResult() == ExpectedResult.SingleResult) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_MULTIPLE_COMMAND_EXECUTE_QUERY_ERR.name(), new String[]{this.m_query});
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            fetchSize = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception ex) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)ex);
            throw err;
        }
        try {
            maxRows = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception ex) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.m_queries.size(); ++i) {
                str.append(this.m_queries.get(i));
                if (i >= this.m_queries.size() - 1) continue;
                str.append(", ");
            }
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", str.toString()}, (Throwable)ex);
            throw err;
        }
        ++this.m_currentExecuteIndex;
        try {
            HashMap<PGMessagingContext, ArrayList<byte[][]>> paramSets = this.buildParameterSets(contexts);
            Iterator<PGCoreUtils.TransactionVerb> txIterator = null;
            Lock txLock = null;
            if (null != this.m_txCommands) {
                txIterator = this.m_txCommands.iterator();
                txLock = this.m_statement.getTransactionLock();
                txLock.lock();
            }
            try {
                PGCoreUtils.TransactionVerb txVerb = PGCoreUtils.TransactionVerb.NONE;
                this.checkCancelled();
                this.m_client.executeAtomicStatement(this.m_contexts, this.m_queries, paramSets, contexts.getCount(), maxRows, fetchSize, this.m_statement.getWarningListener());
                for (int queryCounter = 0; queryCounter < this.m_queries.size(); ++queryCounter) {
                    if (null != txIterator) {
                        txVerb = txIterator.next();
                    }
                    if (PGCoreUtils.TransactionVerb.NONE == txVerb) continue;
                    ((PGMessagingContext)this.m_contexts.get(queryCounter)).closeOperation();
                    this.m_statement.notifyTransaction(txVerb);
                }
            }
            finally {
                if (null != txLock) {
                    txLock.unlock();
                }
            }
        }
        catch (Exception ex) {
            --this.m_currentExecuteIndex;
            if (!(ex instanceof ErrorException)) {
                ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), ex.getMessage());
                err.initCause(ex);
                throw err;
            }
            throw (ErrorException)ex;
        }
        this.m_statement.pushContexts(this.m_contexts);
        for (PGMessagingContext currentCtx : this.m_contexts) {
            currentCtx.addSocketCloseListener(this);
        }
    }

    private HashMap<PGMessagingContext, ArrayList<byte[][]>> buildParameterSets(ExecutionContexts contexts) throws ParamAlreadyPushedException, DefaultParamException, ErrorException {
        int totalParameterCounter = contexts.getMetadata().size();
        if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
            --totalParameterCounter;
        }
        HashMap<PGMessagingContext, ArrayList<byte[][]>> paramSetBuilder = new HashMap<PGMessagingContext, ArrayList<byte[][]>>(this.m_contexts.size());
        if (totalParameterCounter != 0) {
            Iterator<ExecutionContext> parameterItr = contexts.contextIterator();
            while (parameterItr.hasNext()) {
                ExecutionContext paramDataContext = parameterItr.next();
                int dataContextParamCounter = 0;
                for (Integer paramCounter : this.m_parameterCountPerQuery.values()) {
                    byte[][] paramSet = new byte[paramCounter.intValue()][];
                    PGMessagingContext context = null;
                    int paramValueIndex = 0;
                    while (paramValueIndex < paramCounter && dataContextParamCounter < paramDataContext.getInputs().size()) {
                        ParameterInputValue paramDataStruct = paramDataContext.getInputs().get(dataContextParamCounter);
                        paramSet[paramValueIndex] = PGDataTypeUtilities.toUTF8ByteArray(paramDataStruct.getData());
                        ++paramValueIndex;
                        if (null == context) {
                            context = ((PGParameterMetadata)paramDataStruct.getMetadata()).getContext();
                        }
                        ++dataContextParamCounter;
                    }
                    ArrayList<Object> paramSets = paramSetBuilder.get(context);
                    if (null == paramSets) {
                        paramSets = new ArrayList(contexts.getCount());
                    }
                    paramSets.add(paramSet);
                    paramSetBuilder.put(context, paramSets);
                }
            }
        }
        return paramSetBuilder;
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> result = new ArrayList<ParameterMetadata>();
        List<ParameterMetadata> subresult = null;
        for (PGMessagingContext currContext : this.m_contexts) {
            subresult = this.getMetadataForParameters(currContext);
            this.m_parameterCountPerQuery.put(currContext, subresult.size());
            result.addAll(subresult);
        }
        return result;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_queries.get(0));
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext context) {
        return this.m_parameterCountPerQuery.get(context);
    }
}

