/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc41;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.jdbc.jdbc41.S41Connection;
import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.core.NotifiedConnection;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.support.IWarningListener;
import java.sql.SQLException;
import java.util.List;

public class S41NotifiedConnection
extends S41Connection
implements NotifiedConnection {
    public S41NotifiedConnection(IConnection conn, String url) throws SQLException {
        super(conn, url);
    }

    @Override
    public List<Notification> getNotifications() {
        IWarningListener warningListener = this.getWarningListener();
        return PGCoreUtils.getNotifications(warningListener);
    }

    @Override
    public void clearNotifications() {
        IWarningListener warningListener = this.getWarningListener();
        PGCoreUtils.clearNotifications(warningListener);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (!super.isValid(timeout)) {
            return false;
        }
        PGJDBCConnection pgConn = (PGJDBCConnection)this.getDSIConnection();
        return PGDSIOverrideHelper.checkIsValidQuery(pgConn);
    }
}

