/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.client.messages.inbound.NotificationResponse;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PGCoreUtils {
    private static final String HOST_DELIMITER = "//";
    private static final String PORT_DELIMITER = ":";
    private static final String SCHEMA_DELIMITER = "/";
    private static final String KEY_VALUE_DELIMITER = ";";
    private static final String KEY_VALUE_DELIMITER_ALT_START = "?";
    private static final String KEY_VALUE_DELIMITER_ALT = "&";
    private static final String VALUE_DELIMITER = "=";
    private static final char SQL_QUERY_PARAMETER_SIGN = '?';
    private static final char PG_QUERY_PARAMETER_SIGN = '$';
    public static boolean REDSHIFT_SERVER = false;
    public static String SERVER_NAME = null;
    public static String SERVER_VERSION = null;
    public static String NON_VALIDATING_SSL_FACTORY = "org.postgresql.ssl.NonValidatingFactory";
    public static final List<FunctionDefinition> FUNCTION_DEFINITIONS;

    public static String extractUnloadQuery(String unloadStatement) throws ErrorException {
        int start = unloadStatement.indexOf("('") + 2;
        int end = unloadStatement.lastIndexOf("')");
        if (0 > start || 0 > end) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_UNLOAD_QUERY_ERROR.name(), unloadStatement);
        }
        return unloadStatement.substring(start, end);
    }

    public static String insertUnloadQuery(String unloadStatement, String query) throws ErrorException {
        int start = unloadStatement.indexOf("('") + 2;
        int end = unloadStatement.lastIndexOf("')");
        if (0 > start || 0 > end) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_UNLOAD_QUERY_ERROR.name(), unloadStatement);
        }
        StringBuilder newUnloadStatement = new StringBuilder();
        newUnloadStatement.append(unloadStatement.substring(0, start));
        newUnloadStatement.append(query);
        newUnloadStatement.append(unloadStatement.substring(end));
        return newUnloadStatement.toString();
    }

    public static boolean isUnloadStatement(String query) {
        for (int i = 0; i < query.length(); ++i) {
            if (Character.isWhitespace(query.charAt(i)) || i + 6 >= query.length()) continue;
            return query.substring(i, i + 6).toLowerCase().equals("unload");
        }
        return false;
    }

    public static String parameterQueryBuilder(String inputQuery, ArrayList<String> parameterInput) throws ErrorException {
        int currentStrPointer = 0;
        int querySize = inputQuery.length();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        boolean invalidQuery = PGCoreUtils.parameterQueryAnalyzeHelper(inputQuery, '$', currentStrPointer, querySize, indexList);
        if (indexList.size() == 0) {
            return inputQuery;
        }
        if (invalidQuery) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        if (indexList.size() != parameterInput.size()) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        StringBuilder queryBuilder = new StringBuilder();
        int parameterIndex = 0;
        for (int i = 0; i < querySize; ++i) {
            if (!indexList.contains(i)) {
                queryBuilder.append(inputQuery.charAt(i));
                continue;
            }
            queryBuilder.append(parameterInput.get(parameterIndex));
            ++i;
            ++parameterIndex;
        }
        return queryBuilder.toString();
    }

    public static String parameterQueryFormatter(String inputQuery, List<Integer> oids) throws ErrorException {
        int currentStrPointer = 0;
        int querySize = inputQuery.length();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        boolean invalidQuery = PGCoreUtils.parameterQueryAnalyzeHelper(inputQuery, '?', currentStrPointer, querySize, indexList);
        String outputQuery = null;
        if (indexList.size() != 0) {
            StringBuilder queryBuilder = new StringBuilder();
            int parameterCounter = 1;
            for (int i = 0; i < querySize; ++i) {
                if (!indexList.contains(i)) {
                    queryBuilder.append(inputQuery.charAt(i));
                    continue;
                }
                queryBuilder.append('$').append(parameterCounter);
                ++parameterCounter;
            }
            outputQuery = queryBuilder.toString();
        } else {
            outputQuery = inputQuery;
        }
        invalidQuery = PGCoreUtils.generateMetadataForRegisteredFunctions(outputQuery, '$', currentStrPointer, querySize, oids);
        if (invalidQuery) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        return outputQuery;
    }

    public static int parameterCounter(String inputQuery) throws ErrorException {
        int currentStrPointer = 0;
        int querySize = inputQuery.length();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        boolean invalidQuery = PGCoreUtils.parameterQueryAnalyzeHelper(inputQuery, '?', currentStrPointer, querySize, indexList);
        if (indexList.size() == 0) {
            return 0;
        }
        if (invalidQuery) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PARAMETER_QUERY_BUILD_ERR.name());
        }
        StringBuilder queryBuilder = new StringBuilder();
        int parameterCounter = 0;
        for (int i = 0; i < querySize; ++i) {
            if (!indexList.contains(i)) {
                queryBuilder.append(inputQuery.charAt(i));
                continue;
            }
            queryBuilder.append('$').append(++parameterCounter);
        }
        return parameterCounter;
    }

    public static String parseStoredProcedure(String query, PGJDBCConnection con) {
        int validProcedureLength = 6;
        String validProcedureCALLFormat = "CALL";
        String modifiedQuery = query.trim();
        if (modifiedQuery.charAt(0) == '{' && modifiedQuery.length() > 1 && (modifiedQuery = modifiedQuery.substring(1, modifiedQuery.length()).trim()).length() > 6 && modifiedQuery.charAt(modifiedQuery.length() - 1) == '}') {
            String callSyntex = modifiedQuery.trim().substring(0, "CALL".length()).toUpperCase();
            if (!callSyntex.equals("CALL")) {
                con.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_PROCEDURE_CALL_FORMAT_ERROR.name()));
                return query;
            }
            modifiedQuery = PGCoreUtils.storedProcedureQueryFormatter(modifiedQuery, "CALL");
            return modifiedQuery;
        }
        return query;
    }

    public static boolean parseSubName(String subname, Properties properties, boolean ifOpenSourceSubProtocol) {
        if (null == subname || 0 == subname.length() || !subname.startsWith(HOST_DELIMITER)) {
            return false;
        }
        String keyValueStr = subname.trim().substring(HOST_DELIMITER.length());
        if (0 == keyValueStr.length()) {
            return false;
        }
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] keyValuePairs = keyValueStr.split(KEY_VALUE_DELIMITER);
        if (1 == keyValuePairs.length && keyValueStr.contains(KEY_VALUE_DELIMITER_ALT_START)) {
            keyValuePairs = keyValueStr.split("\\?|\\&");
        }
        for (int i = 0; i < keyValuePairs.length; ++i) {
            if (i == 0) {
                String[] Conn_Type = new String[]{"Host", "Port", "ConnSchema"};
                String connectionInfo = keyValuePairs[0];
                String host = null;
                String port = null;
                String schema = null;
                int portIndex = connectionInfo.indexOf(PORT_DELIMITER);
                int schemaIndex = connectionInfo.indexOf(SCHEMA_DELIMITER);
                if (-1 == portIndex) {
                    if (-1 != schemaIndex) {
                        host = connectionInfo.substring(0, schemaIndex);
                        schema = connectionInfo.substring(schemaIndex + 1, connectionInfo.length());
                        map.put(Conn_Type[2], schema);
                    } else {
                        host = connectionInfo;
                    }
                    map.put(Conn_Type[0], host);
                    continue;
                }
                host = connectionInfo.substring(0, portIndex);
                map.put(Conn_Type[0], host);
                if (-1 != schemaIndex) {
                    port = connectionInfo.substring(portIndex + 1, schemaIndex);
                    map.put(Conn_Type[1], port);
                    schema = connectionInfo.substring(schemaIndex + 1, connectionInfo.length());
                    map.put(Conn_Type[2], schema);
                    continue;
                }
                port = connectionInfo.substring(portIndex + 1, connectionInfo.length());
                map.put(Conn_Type[1], port);
                continue;
            }
            String[] keyValue = keyValuePairs[i].split(VALUE_DELIMITER);
            if (2 > keyValue.length) {
                map.put(keyValue[0], "");
                continue;
            }
            map.put(keyValue[0], keyValue[1]);
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
        if (ifOpenSourceSubProtocol && map.containsKey("OpenSourceSubProtocolOverride") && Boolean.parseBoolean((String)map.get("OpenSourceSubProtocolOverride"))) {
            try {
                Class.forName("org.postgresql.Driver");
                return false;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        properties.clear();
        properties.putAll((Map<?, ?>)map);
        return true;
    }

    public static TransactionVerb parseTransactionVerb(String input) {
        TransactionVerb verb = TransactionVerb.NONE;
        boolean hasSemicolon = false;
        block9: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (input.charAt(i)) {
                case 'B': 
                case 'b': {
                    String rest = "egin";
                    if (!hasSemicolon && TransactionVerb.NONE == verb && PGCoreUtils.matchesRegionCI(input, "egin", i + 1)) {
                        verb = TransactionVerb.BEGIN;
                        i += "egin".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case 'C': 
                case 'c': {
                    String rest = "ommit";
                    if (!hasSemicolon && TransactionVerb.NONE == verb && PGCoreUtils.matchesRegionCI(input, "ommit", i + 1)) {
                        verb = TransactionVerb.COMMIT;
                        i += "ommit".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case 'R': 
                case 'r': {
                    String rest = "ollback";
                    if (!hasSemicolon && TransactionVerb.NONE == verb && PGCoreUtils.matchesRegionCI(input, "ollback", i + 1)) {
                        verb = TransactionVerb.ROLLBACK;
                        i += "ollback".length();
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case '#': {
                    ++i;
                    while (input.length() > i && '\n' != input.charAt(i)) {
                        ++i;
                    }
                    continue block9;
                }
                case '-': {
                    if (i + 1 < input.length() && '-' == input.charAt(i + 1)) {
                        i += 2;
                        while (input.length() > i && '\n' != input.charAt(i)) {
                            ++i;
                        }
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case '/': {
                    int next;
                    if (i + 1 < input.length() && '*' == input.charAt(i + 1) && 0 < (next = input.indexOf("*/", i + 2))) {
                        i = next + 1;
                        continue block9;
                    }
                    return TransactionVerb.NONE;
                }
                case ';': {
                    hasSemicolon = true;
                    continue block9;
                }
                default: {
                    if (Character.isWhitespace(ch)) continue block9;
                    return TransactionVerb.NONE;
                }
            }
        }
        return verb;
    }

    public static int safeLongToInt(long inputLongValue) throws ErrorException {
        if (inputLongValue < Integer.MIN_VALUE || inputLongValue > Integer.MAX_VALUE) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_DATA_CONVERSION_ERROR_INTEGER.name(), new BigDecimal(inputLongValue).toString(), ExceptionType.DATA);
        }
        return (int)inputLongValue;
    }

    public static List<Notification> getNotifications(IWarningListener warningListener) {
        List<Warning> warnings;
        ArrayList<NotificationResponse> notifications = null;
        if (null != warningListener && null != (warnings = warningListener.getWarnings())) {
            NotificationResponse currentNotification = null;
            notifications = new ArrayList<NotificationResponse>();
            for (Warning currentWarning : warnings) {
                if (null == currentWarning || null == (currentNotification = new NotificationResponse(currentWarning)).getName()) continue;
                notifications.add(currentNotification);
            }
        }
        return notifications;
    }

    public static void clearNotifications(IWarningListener warningListener) {
        List<Warning> warnings;
        if (null != warningListener && null != (warnings = warningListener.getWarnings())) {
            warnings.clear();
        }
    }

    private static boolean parameterQueryAnalyzeHelper(String inputQuery, char parameterFormat, int currentStrPointer, int querySize, ArrayList<Integer> indexList) {
        ParseStatus status = new ParseStatus();
        status.currentStrPointer = currentStrPointer;
        while (status.currentStrPointer < querySize) {
            PGCoreUtils.skipEscapedContent(inputQuery, status, querySize);
            if (inputQuery.charAt(status.currentStrPointer) == parameterFormat) {
                indexList.add(status.currentStrPointer);
                ++status.currentStrPointer;
                continue;
            }
            ++status.currentStrPointer;
        }
        return status.invalidQuery;
    }

    private static boolean generateMetadataForRegisteredFunctions(String inputQuery, char parameterFormat, int currentStrPointer, int querySize, List<Integer> parameterOIDvalues) {
        boolean invalidQuery = false;
        String workingQuery = inputQuery.toLowerCase();
        HashMap<Integer, FunctionDefinition> functionInstances = new HashMap<Integer, FunctionDefinition>();
        block0: for (FunctionDefinition fn : FUNCTION_DEFINITIONS) {
            int functionLocationPointer = currentStrPointer;
            while (-1 != (functionLocationPointer = workingQuery.indexOf(fn.functionName, functionLocationPointer))) {
                functionInstances.put(functionLocationPointer, fn);
                if ((functionLocationPointer += fn.functionName.length()) < workingQuery.length()) continue;
                continue block0;
            }
        }
        if (0 == functionInstances.size()) {
            return false;
        }
        ParseStatus status = new ParseStatus();
        status.currentStrPointer = currentStrPointer;
        while (status.currentStrPointer < querySize) {
            FunctionDefinition fn;
            PGCoreUtils.skipEscapedContent(workingQuery, status, querySize);
            fn = (FunctionDefinition)functionInstances.get(status.currentStrPointer);
            if (null != fn && PGCoreUtils.parseFunctionArguments(workingQuery, status, querySize, fn, functionInstances, parameterOIDvalues)) {
                return true;
            }
            if (workingQuery.charAt(status.currentStrPointer) == parameterFormat) {
                parameterOIDvalues.add(0);
                ++status.currentStrPointer;
                continue;
            }
            ++status.currentStrPointer;
        }
        return invalidQuery;
    }

    private static boolean parseFunctionArguments(String inputQuery, ParseStatus status, int querySize, FunctionDefinition functionToParse, Map<Integer, FunctionDefinition> functionInstances, List<Integer> parameterOIDvalues) {
        int nestedFunctionLevel = 0;
        int encounteredArgumentCount = 0;
        char preceedingCharacter = inputQuery.charAt(status.currentStrPointer - 1);
        if (Character.isLetterOrDigit(preceedingCharacter)) {
            return false;
        }
        status.currentStrPointer += functionToParse.functionName.length();
        int openingBracket = inputQuery.indexOf(40, status.currentStrPointer);
        if (-1 == openingBracket) {
            return true;
        }
        while (status.currentStrPointer < openingBracket) {
            if (!Character.isWhitespace(inputQuery.charAt(status.currentStrPointer))) {
                return false;
            }
            ++status.currentStrPointer;
        }
        ++status.currentStrPointer;
        block1: while (status.currentStrPointer < querySize) {
            char currentChar;
            PGCoreUtils.skipEscapedContent(inputQuery, status, querySize);
            FunctionDefinition fn = functionInstances.get(status.currentStrPointer);
            if (null != fn && PGCoreUtils.parseFunctionArguments(inputQuery, status, querySize, fn, functionInstances, parameterOIDvalues)) {
                return true;
            }
            if (0 == nestedFunctionLevel) {
                String remainingQuery = inputQuery.substring(status.currentStrPointer);
                for (DelimiterDefinition delimiterSet : functionToParse.delimiterSets) {
                    String delimiterTest;
                    if (delimiterSet.delimiters.size() <= encounteredArgumentCount || !remainingQuery.startsWith(delimiterTest = delimiterSet.delimiters.get(encounteredArgumentCount)) || delimiterSet.isWhiteSpaceRequired && (!delimiterSet.isWhiteSpaceRequired || !Character.isWhitespace(inputQuery.charAt(status.currentStrPointer - 1)) || !Character.isWhitespace(remainingQuery.charAt(delimiterTest.length())))) continue;
                    ++encounteredArgumentCount;
                    status.currentStrPointer += delimiterTest.length();
                    continue block1;
                }
            }
            if ('$' == (currentChar = inputQuery.charAt(status.currentStrPointer))) {
                if (0 == nestedFunctionLevel) {
                    parameterOIDvalues.add(functionToParse.oid.get(encounteredArgumentCount));
                } else {
                    parameterOIDvalues.add(0);
                }
            } else if ('(' == currentChar) {
                ++nestedFunctionLevel;
            } else if (')' == currentChar) {
                if (0 == nestedFunctionLevel) {
                    if (status.currentStrPointer < inputQuery.length() - 1) {
                        ++status.currentStrPointer;
                    }
                    return false;
                }
                --nestedFunctionLevel;
            }
            ++status.currentStrPointer;
        }
        return false;
    }

    private static boolean matchesRegionCI(String str1, String str2, int offset1) {
        return str1.regionMatches(true, offset1, str2, 0, str2.length());
    }

    private static void skipEscapedContent(String inputQuery, ParseStatus status, int endIndex) {
        int position = status.currentStrPointer;
        switch (inputQuery.charAt(position)) {
            case '[': {
                int indexOfSingleBracket = inputQuery.indexOf(93, position + 1);
                if (indexOfSingleBracket != -1) {
                    status.currentStrPointer = indexOfSingleBracket;
                    break;
                }
                status.invalidQuery = true;
                break;
            }
            case '\'': {
                if (0 != position && (0 >= position || '\\' == inputQuery.charAt(position - 1))) break;
                int indexOfNextSingleQuote = inputQuery.indexOf(39, position + 1);
                while (0 < indexOfNextSingleQuote && indexOfNextSingleQuote < inputQuery.length() && '\\' == inputQuery.charAt(indexOfNextSingleQuote - 1)) {
                    indexOfNextSingleQuote = inputQuery.indexOf(39, indexOfNextSingleQuote + 1);
                }
                if (indexOfNextSingleQuote != -1) {
                    status.currentStrPointer = indexOfNextSingleQuote;
                    break;
                }
                status.invalidQuery = true;
                break;
            }
            case '\"': {
                if (0 != position && (0 >= position || '\\' == inputQuery.charAt(position - 1))) break;
                int indexOfNextDoubleQuote = inputQuery.indexOf(34, position + 1);
                while (0 < indexOfNextDoubleQuote && indexOfNextDoubleQuote < inputQuery.length() && '\\' == inputQuery.charAt(indexOfNextDoubleQuote - 1)) {
                    indexOfNextDoubleQuote = inputQuery.indexOf(34, indexOfNextDoubleQuote + 1);
                }
                if (indexOfNextDoubleQuote != -1) {
                    status.currentStrPointer = indexOfNextDoubleQuote;
                    break;
                }
                status.invalidQuery = true;
                break;
            }
            case '-': {
                if (position + 1 >= endIndex || inputQuery.charAt(position + 1) != '-') break;
                int indexOfNewLine = inputQuery.indexOf("\n", position + 1);
                if (indexOfNewLine != -1) {
                    status.currentStrPointer = indexOfNewLine;
                    break;
                }
                status.invalidQuery = true;
                break;
            }
            case '/': {
                if (position + 2 >= endIndex || inputQuery.charAt(position + 1) != '*') break;
                int indexOfEndComment = inputQuery.indexOf("*/", position + 1);
                if (indexOfEndComment != -1) {
                    status.currentStrPointer = indexOfEndComment + 1;
                    break;
                }
                status.invalidQuery = true;
            }
        }
    }

    private static String storedProcedureQueryFormatter(String query, String format) {
        String selectSyntax = "SELECT";
        StringBuilder procedureToPGQuery = new StringBuilder();
        String formatQuery = query.substring(0, query.length() - 1).trim();
        if ((formatQuery = formatQuery.substring(format.length())).charAt(query.length() - 1) != ')') {
            formatQuery = formatQuery + "()";
        }
        procedureToPGQuery.append("SELECT").append(" ").append(formatQuery.trim());
        return procedureToPGQuery.toString();
    }

    public static boolean willAdditionOverflow(long left, long right) {
        return ((left ^ right ^ 0xFFFFFFFFFFFFFFFFL) & (left ^ left + right)) < 0L;
    }

    static {
        ArrayList<FunctionDefinition> functionList = new ArrayList<FunctionDefinition>();
        FunctionDefinition func = new FunctionDefinition();
        func.functionName = "substring".toLowerCase();
        func.oid = new ArrayList<Integer>();
        func.oid.add(1043);
        func.oid.add(23);
        func.oid.add(23);
        DelimiterDefinition delimiterSet1 = new DelimiterDefinition();
        delimiterSet1.isWhiteSpaceRequired = false;
        delimiterSet1.delimiters.add(",");
        delimiterSet1.delimiters.add(",");
        func.delimiterSets.add(delimiterSet1);
        DelimiterDefinition delimiterSet2 = new DelimiterDefinition();
        delimiterSet2.isWhiteSpaceRequired = true;
        delimiterSet2.delimiters.add("from");
        delimiterSet2.delimiters.add("for");
        func.delimiterSets.add(delimiterSet2);
        functionList.add(func);
        FUNCTION_DEFINITIONS = Collections.unmodifiableList(functionList);
    }

    private static class ParseStatus {
        int currentStrPointer;
        boolean invalidQuery = false;

        private ParseStatus() {
        }
    }

    public static enum TransactionVerb {
        BEGIN,
        COMMIT,
        ROLLBACK,
        NONE;

    }

    public static class DelimiterDefinition {
        List<String> delimiters = new ArrayList<String>();
        boolean isWhiteSpaceRequired;
    }

    public static class FunctionDefinition {
        public String functionName;
        public List<Integer> oid;
        public List<DelimiterDefinition> delimiterSets = new ArrayList<DelimiterDefinition>();
    }
}

