/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Query
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] query;

    public Query(String query, IPGLogger logger) {
        this.query = PGDataTypeUtilities.toUTF8ByteArray(query);
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)81);
        buffer.put(sizebytes);
        buffer.put(this.query);
        buffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + this.query.length + 1;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "=>FE Query(" + new String(this.query) + ")";
        logger.logDebugExternal(message);
    }
}

