/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration.gui;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.integration.gui.WindowChecker;
import java.awt.Window;

public class AwtAndFxWindowChecker
extends WindowChecker {
    public AwtAndFxWindowChecker(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected boolean checkExecute() {
        return AwtAndFxWindowChecker.hasVisibleWindows();
    }

    public static boolean hasVisibleWindows() {
        if (AwtAndFxWindowChecker.isShowing(Window.getWindows())) {
            return true;
        }
        boolean javaFxWindowShown = VersionSpecificHelper.isJavaFxWindowShown();
        if (javaFxWindowShown) {
            GUIHelper.setLafUnconditional();
        }
        return javaFxWindowShown;
    }

    private static boolean isShowing(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing()) {
                return true;
            }
            if (!AwtAndFxWindowChecker.isShowing(window.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }
}

