/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.FileAttributesHelper;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;

public class BackupFileForRollbackAction
extends SystemInstallAction {
    private File file;
    private boolean delete;
    private boolean failIfRenameDoesntWork = false;
    private boolean fallBackToParentDir = true;
    private File backupFile;
    private long modTime;
    private String posixPermissions;
    private boolean fileDidNotExist = false;

    public BackupFileForRollbackAction() {
    }

    public BackupFileForRollbackAction(File file, boolean delete) {
        this.file = file;
        this.delete = delete;
    }

    public BackupFileForRollbackAction(File file, boolean delete, boolean failIfRenameDoesntWork) {
        this.file = file;
        this.delete = delete;
        this.failIfRenameDoesntWork = failIfRenameDoesntWork;
    }

    public BackupFileForRollbackAction(File file, boolean delete, boolean failIfRenameDoesntWork, boolean fallBackToParentDir) {
        this.file = file;
        this.delete = delete;
        this.failIfRenameDoesntWork = failIfRenameDoesntWork;
        this.fallBackToParentDir = fallBackToParentDir;
    }

    public File getFile() {
        return BackupFileForRollbackAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isFailIfRenameDoesntWork() {
        return this.failIfRenameDoesntWork;
    }

    public void setFailIfRenameDoesntWork(boolean failIfRenameDoesntWork) {
        this.failIfRenameDoesntWork = failIfRenameDoesntWork;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (this.getFile() == null || this.getFile().getPath().trim().length() == 0) {
            return false;
        }
        File usedFile = context.getDestinationFile(this.getFile());
        if (!usedFile.exists()) {
            this.fileDidNotExist = true;
            return true;
        }
        Util.logInfo(null, "Backing up " + usedFile.getAbsolutePath());
        try {
            this.modTime = usedFile.lastModified();
            if (!Util.isWindows()) {
                try {
                    this.posixPermissions = FileAttributesHelper.getPosixFilePermissions(usedFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.backupFile = File.createTempFile("i4b", null);
            if (this.delete) {
                this.backupFile.delete();
                if (!usedFile.renameTo(this.backupFile)) {
                    File newBackupFile;
                    if (this.fallBackToParentDir) {
                        try {
                            newBackupFile = File.createTempFile("i4b", null, usedFile.getParentFile());
                            newBackupFile.delete();
                        }
                        catch (IOException e) {
                            newBackupFile = this.backupFile;
                        }
                    } else {
                        newBackupFile = this.backupFile;
                    }
                    if (usedFile.renameTo(newBackupFile)) {
                        this.backupFile = newBackupFile;
                    } else {
                        if (this.failIfRenameDoesntWork) {
                            this.backupFile = null;
                            return false;
                        }
                        FileUtil.copyFile(usedFile, this.backupFile);
                        usedFile.delete();
                    }
                }
            } else {
                FileUtil.copyFile(usedFile, this.backupFile);
            }
            FileInstaller.getInstance().registerCleanupFile(this.backupFile);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            this.backupFile.delete();
            this.backupFile = null;
            return false;
        }
        return true;
    }

    @Override
    public void rollback(InstallerContext context) {
        if (this.fileDidNotExist) {
            context.getDestinationFile(this.getFile()).delete();
        } else if (this.backupFile != null && this.backupFile.exists()) {
            File usedFile = context.getDestinationFile(this.getFile());
            try {
                usedFile.delete();
                if (!this.backupFile.renameTo(usedFile) && !this.failIfRenameDoesntWork) {
                    FileUtil.copyFile(this.backupFile, usedFile);
                }
                usedFile.setLastModified(this.modTime);
                if (this.posixPermissions != null) {
                    try {
                        UnixFileSystem.setMode(this.posixPermissions, usedFile);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.backupFile.delete();
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
    }

    public File getBackupFile() {
        return this.backupFile;
    }
}

