/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.util.io.NoCloseOutputStream;

public class StretchDIBits
extends EMFTag
implements EMFConstants {
    public static final int size = 80;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xSrc;
    private int ySrc;
    private int widthSrc;
    private int heightSrc;
    private int usage;
    private int dwROP;
    private Color bkg;
    private BitmapInfo bmi;
    private BufferedImage image;

    public StretchDIBits() {
        super(81, 1);
    }

    public StretchDIBits(Rectangle bounds, int x, int y, int width, int height, BufferedImage image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.xSrc = 0;
        this.ySrc = 0;
        this.widthSrc = image.getWidth();
        this.heightSrc = image.getHeight();
        this.usage = 0;
        this.dwROP = 0xCC0020;
        this.bkg = bkg;
        this.image = image;
        this.bmi = null;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        StretchDIBits tag = new StretchDIBits();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        emf.readDWORD();
        emf.readDWORD();
        emf.readDWORD();
        emf.readDWORD();
        tag.usage = emf.readDWORD();
        tag.dwROP = emf.readDWORD();
        tag.widthSrc = emf.readLONG();
        tag.heightSrc = emf.readLONG();
        tag.bmi = new BitmapInfo(emf);
        tag.image = EMFImageLoader.readImage(tag.bmi.getHeader(), tag.width, tag.height, emf, len - 72 - 40, null);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeLONG(this.x);
        emf.writeLONG(this.y);
        emf.writeLONG(this.xSrc);
        emf.writeLONG(this.ySrc);
        emf.writeLONG(this.widthSrc);
        emf.writeLONG(this.heightSrc);
        emf.writeDWORD(80);
        emf.writeDWORD(40);
        emf.writeDWORD(120);
        emf.pushBuffer();
        int encode = 0;
        ImageGraphics2D.writeImage(this.image, "RAW".toLowerCase(), (Properties)ImageGraphics2D.getRAWProperties(this.bkg, "BGR"), (OutputStream)new NoCloseOutputStream(emf));
        int length = emf.popBuffer();
        emf.writeDWORD(length);
        emf.writeDWORD(this.usage);
        emf.writeDWORD(this.dwROP);
        emf.writeLONG(this.width);
        emf.writeLONG(this.height);
        BitmapInfoHeader header = new BitmapInfoHeader(this.widthSrc, this.heightSrc, 24, encode, length, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(header);
        this.bmi.write(emf);
        emf.append();
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  xSrc, ySrc, widthSrc, heightSrc: " + this.xSrc + " " + this.ySrc + " " + this.widthSrc + " " + this.heightSrc + "\n  usage: " + this.usage + "\n  dwROP: " + this.dwROP + "\n  bkg: " + this.bkg + "\n" + this.bmi.toString();
    }

    public void render(EMFRenderer renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, this.x, this.y, this.widthSrc, this.heightSrc);
        }
    }
}

