/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;

public final class ExasolTableCache
extends JDBCStructCache<ExasolSchema, ExasolTable, ExasolTableColumn> {
    private static final String SQL_COLS_TAB = "SELECT c.* FROM SYS.%s_COLUMNS c WHERE COLUMN_SCHEMA = '%s' AND COLUMN_TABLE = '%s' ORDER BY COLUMN_ORDINAL_POSITION ";
    private static final String SQL_COLS_ALL = "SELECT c.* FROM SYS.%s_COLUMNS c WHERE COLUMN_SCHEMA = '%s' AND COLUMN_OBJECT_TYPE = 'TABLE' ORDER BY COLUMN_ORDINAL_POSITION ";
    private static final String SQL_TABLES = "SELECT * FROM \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_SCHEM = '%s' and TABLE_TYPE = 'TABLE' order by TABLE_NAME";

    public ExasolTableCache() {
        super((Object)"TABLE_NAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema) throws SQLException {
        String sql = String.format(SQL_TABLES, exasolSchema.getName());
        JDBCStatement dbstat = session.createStatement();
        dbstat.setQueryString(sql);
        return dbstat;
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull ExasolSchema exasolSchema, @Nullable ExasolTable exasolTable) throws SQLException {
        String tablePrefix = exasolSchema.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL);
        String sql = exasolTable != null ? String.format(SQL_COLS_TAB, tablePrefix, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(exasolTable.getName())) : String.format(SQL_COLS_ALL, tablePrefix, ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbstat = session.createStatement();
        ((JDBCStatementImpl)dbstat).setQueryString(sql);
        return dbstat;
    }

    protected ExasolTableColumn fetchChild(@NotNull JDBCSession session, @NotNull ExasolSchema owner, @NotNull ExasolTable parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolTableColumn(session.getProgressMonitor(), parent, (ResultSet)dbResult);
    }

    protected ExasolTable fetchObject(@NotNull JDBCSession session, @NotNull ExasolSchema owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        return new ExasolTable(session.getProgressMonitor(), owner, (ResultSet)resultSet);
    }
}

