/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.dialogs.EditObjectFilterDialog;

public class NavigatorHandlerFilterConfig
extends NavigatorHandlerObjectCreateBase
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        if (node instanceof DBNDatabaseItem) {
            node = node.getParentNode();
        }
        if (node instanceof DBNDatabaseFolder) {
            NavigatorHandlerFilterConfig.configureFilters(HandlerUtil.getActiveShell((ExecutionEvent)event), node);
        }
        return null;
    }

    public static void configureFilters(Shell shell, DBNNode node) {
        DBNDatabaseFolder folder = (DBNDatabaseFolder)node;
        DBXTreeItem itemsMeta = folder.getItemsMeta();
        if (itemsMeta != null) {
            DBSObjectFilter objectFilter = folder.getNodeFilter(itemsMeta, true);
            if (objectFilter == null) {
                objectFilter = new DBSObjectFilter();
            }
            DBPDataSourceRegistry dsRegistry = folder.getOwnerProject().getDataSourceRegistry();
            boolean globalFilter = folder.getValueObject() instanceof DBPDataSource;
            String parentName = "?";
            if (folder.getValueObject() instanceof DBSObject) {
                parentName = ((DBSObject)folder.getValueObject()).getName();
            }
            EditObjectFilterDialog dialog = new EditObjectFilterDialog(shell, dsRegistry, globalFilter ? "All " + node.getNodeType() : String.valueOf(node.getNodeType()) + " of " + parentName, objectFilter, globalFilter);
            switch (dialog.open()) {
                case 0: {
                    folder.setNodeFilter(itemsMeta, dialog.getFilter());
                    NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(folder));
                    break;
                }
                case 1000: {
                    objectFilter = folder.getDataSource().getContainer().getObjectFilter(folder.getChildrenClass(), null, true);
                    dialog = new EditObjectFilterDialog(shell, dsRegistry, "All " + node.getNodeType(), objectFilter != null ? objectFilter : new DBSObjectFilter(), true);
                    if (dialog.open() != 0) break;
                    folder.getDataSource().getContainer().setObjectFilter(folder.getChildrenClass(), null, dialog.getFilter());
                    folder.getDataSource().getContainer().persistConfiguration();
                    NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(folder));
                }
            }
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!updateUI) {
            return;
        }
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node instanceof DBNDatabaseItem) {
            node = node.getParentNode();
        }
        if (node != null) {
            element.setText(NLS.bind((String)UINavigatorMessages.actions_navigator_filter_objects, (Object)node.getNodeType()));
        }
    }
}

