/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public abstract class AbstractProcedure<DATASOURCE extends DBPDataSource, CONTAINER extends DBSObjectContainer>
implements DBSProcedure,
DBPSaveableObject,
DBPImageProvider {
    protected CONTAINER container;
    protected String name;
    protected String description;
    protected boolean persisted;

    protected AbstractProcedure(CONTAINER container, boolean persisted) {
        this.container = container;
        this.persisted = persisted;
    }

    protected AbstractProcedure(CONTAINER container, boolean persisted, String name, String description) {
        this(container, persisted);
        this.name = name;
        this.description = description;
    }

    public CONTAINER getContainer() {
        return this.container;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Property(viewable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public DATASOURCE getDataSource() {
        return (DATASOURCE)this.container.getDataSource();
    }

    @Override
    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Override
    public DBSObject getParentObject() {
        return this.container;
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        if (this.getProcedureType() == DBSProcedureType.FUNCTION) {
            return DBIcon.TREE_FUNCTION;
        }
        return DBIcon.TREE_PROCEDURE;
    }
}

