/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.sql.Ref;
import java.sql.SQLException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDReference;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCReference
implements DBDReference {
    private static final Log log = Log.getLog(JDBCReference.class);
    private DBSDataType type;
    private Ref value;
    private Object refObject;

    public JDBCReference(DBSDataType type, Ref value) throws DBCException {
        this.type = type;
        this.value = value;
    }

    public Ref getValue() throws DBCException {
        return this.value;
    }

    @Override
    public Object getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void release() {
        this.type = null;
        this.value = null;
    }

    @Override
    public DBSDataType getReferencedType() {
        return this.type;
    }

    @Override
    public Object getReferencedObject(DBCSession session) throws DBCException {
        if (this.refObject == null) {
            try {
                session.getProgressMonitor().beginTask("Retrieve references object", 3);
                try {
                    session.getProgressMonitor().worked(1);
                    Object refValue = this.value.getObject();
                    session.getProgressMonitor().worked(1);
                    DBDValueHandler valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)this.type);
                    this.refObject = valueHandler.getValueFromObject(session, this.type, refValue, false, false);
                    session.getProgressMonitor().worked(1);
                }
                finally {
                    session.getProgressMonitor().done();
                }
            }
            catch (SQLException sQLException) {
                throw new DBCException("Can't obtain object reference");
            }
        }
        return this.refObject;
    }

    public String toString() {
        try {
            return this.value == null ? "[NULL]" : this.value.getBaseTypeName();
        }
        catch (SQLException sQLException) {
            return this.value.toString();
        }
    }
}

