/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text.parser.rules;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPWordDetector;

public class WordRule
implements TPRule {
    protected static final int UNDEFINED = -1;
    private TPWordDetector fDetector;
    private TPToken fDefaultToken;
    private int fColumn = -1;
    private Map<String, TPToken> fWords = new HashMap<String, TPToken>();
    private StringBuilder fBuffer = new StringBuilder();
    private boolean fIgnoreCase;

    public WordRule(TPWordDetector detector) {
        this(detector, TPTokenAbstract.UNDEFINED, false);
    }

    public WordRule(TPWordDetector detector, TPToken defaultToken) {
        this(detector, defaultToken, false);
    }

    public WordRule(TPWordDetector detector, TPToken defaultToken, boolean ignoreCase) {
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        this.fIgnoreCase = ignoreCase;
    }

    public void addWord(String word, TPToken token) {
        if (this.fIgnoreCase) {
            word = word.toLowerCase();
        }
        this.fWords.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            TPToken token;
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            if (this.fIgnoreCase) {
                buffer = buffer.toLowerCase();
            }
            if ((token = this.fWords.get(buffer)) != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return TPTokenAbstract.UNDEFINED;
    }

    private void unreadBuffer(TPCharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

