/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.io.File;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DialogUtils {
    private static final Log log = Log.getLog(DialogUtils.class);
    private static final String DIALOG_FOLDER_PROPERTY = "dialog.default.folder";
    public static String curDialogFolder = DBWorkbench.getPlatform().getPreferenceStore().getString("dialog.default.folder");

    static {
        if (CommonUtils.isEmpty((String)curDialogFolder)) {
            curDialogFolder = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
    }

    public static File selectFileForSave(Shell parentShell, String valueName) {
        return DialogUtils.selectFileForSave(parentShell, "Save Content As", null, valueName);
    }

    public static File selectFileForSave(Shell parentShell, String title, String[] filterExt, @Nullable String fileName) {
        FileDialog fileDialog = new FileDialog(parentShell, 8192);
        fileDialog.setText(title);
        fileDialog.setOverwrite(true);
        if (filterExt != null) {
            fileDialog.setFilterExtensions(filterExt);
        }
        if (fileName != null) {
            fileDialog.setFileName(fileName);
        }
        if (CommonUtils.isEmpty((String)(fileName = DialogUtils.openFileDialog(fileDialog)))) {
            return null;
        }
        File saveFile = new File(fileName);
        File saveDir = saveFile.getParentFile();
        if (!saveDir.exists()) {
            DBWorkbench.getPlatformUI().showError("Bad file name", "Directory '" + saveDir.getAbsolutePath() + "' does not exists");
            return null;
        }
        return saveFile;
    }

    public static File openFile(Shell parentShell) {
        return DialogUtils.openFile(parentShell, null);
    }

    public static File openFile(Shell parentShell, String[] filterExt) {
        String fileName;
        FileDialog fileDialog = new FileDialog(parentShell, 4096);
        if (filterExt != null) {
            fileDialog.setFilterExtensions(filterExt);
        }
        if (CommonUtils.isEmpty((String)(fileName = DialogUtils.openFileDialog(fileDialog)))) {
            return null;
        }
        File loadFile = new File(fileName);
        if (!loadFile.exists()) {
            MessageBox aMessageBox = new MessageBox(parentShell, 40);
            aMessageBox.setText("File doesn't exists");
            aMessageBox.setMessage("The file " + loadFile.getAbsolutePath() + " doesn't exists.");
            aMessageBox.open();
            return null;
        }
        return loadFile;
    }

    public static String openFileDialog(FileDialog fileDialog) {
        String fileName;
        if (curDialogFolder != null) {
            fileDialog.setFilterPath(curDialogFolder);
        }
        if (!CommonUtils.isEmpty((String)(fileName = fileDialog.open()))) {
            DialogUtils.setCurDialogFolder(fileDialog.getFilterPath());
        }
        return fileName;
    }

    public static String getCurDialogFolder() {
        return curDialogFolder;
    }

    public static void setCurDialogFolder(String curDialogFolder) {
        DBWorkbench.getPlatform().getPreferenceStore().setValue(DIALOG_FOLDER_PROPERTY, curDialogFolder);
        DialogUtils.curDialogFolder = curDialogFolder;
    }

    @NotNull
    public static Text createOutputFolderChooser(Composite parent, @Nullable String label, @Nullable ModifyListener changeListener) {
        return DialogUtils.createOutputFolderChooser(parent, label, null, changeListener);
    }

    @NotNull
    public static Text createOutputFolderChooser(final Composite parent, @Nullable String label, @Nullable String value, @Nullable ModifyListener changeListener) {
        final String message = label != null ? label : UIMessages.output_label_directory;
        UIUtils.createControlLabel(parent, message);
        TextWithOpen directoryText = new TextWithOpen(parent){

            @Override
            protected void openBrowser() {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 0);
                dialog.setMessage("Choose target directory");
                dialog.setText(message);
                String directory = this.getText();
                if (CommonUtils.isEmpty((String)directory)) {
                    directory = curDialogFolder;
                }
                if (!CommonUtils.isEmpty((String)directory)) {
                    dialog.setFilterPath(directory);
                }
                if ((directory = dialog.open()) != null) {
                    this.setText(directory);
                    DialogUtils.setCurDialogFolder(directory);
                }
            }
        };
        directoryText.setLayoutData(new GridData(768));
        if (value != null) {
            directoryText.getTextControl().setText(value);
        }
        if (changeListener != null) {
            directoryText.getTextControl().addModifyListener(changeListener);
        }
        return directoryText.getTextControl();
    }
}

